/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.service.auth.OAuthClient;

public abstract class Auth {
    protected String accessToken;
    protected String refreshToken;
    protected long expiresIn;
    protected OAuthClient client;

    protected boolean needRefresh() {
        return this.accessToken == null || System.currentTimeMillis() / 1000L > this.expiresIn;
    }

    public String tokenType() {
        return "Bearer";
    }

    public String token() {
        if (!this.needRefresh()) {
            return this.accessToken;
        }
        OAuthToken resp = this.client.refreshToken(this.refreshToken);
        this.accessToken = resp.getAccessToken();
        this.refreshToken = resp.getRefreshToken();
        this.expiresIn = resp.getExpiresIn().intValue();
        return this.accessToken;
    }
}

