/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.exception;

import com.coze.openapi.client.exception.AuthErrorCode;
import com.coze.openapi.client.exception.CozeError;

public class CozeAuthException
extends RuntimeException {
    private final int statusCode;
    private final AuthErrorCode code;
    private final String errorMessage;
    private final String param;
    private final String logID;

    public CozeAuthException(CozeError error, Exception parent, int statusCode, String logID) {
        super(error.errorMessage, parent);
        this.statusCode = statusCode;
        this.errorMessage = error.errorMessage;
        this.code = AuthErrorCode.fromString(error.errorCode);
        this.param = error.error;
        this.logID = logID;
    }

    public CozeAuthException(CozeError error, int statusCode, String logID) {
        super(error.errorMessage);
        this.statusCode = statusCode;
        this.errorMessage = error.errorMessage;
        this.code = AuthErrorCode.fromString(error.errorCode);
        this.param = error.error;
        this.logID = logID;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public AuthErrorCode getCode() {
        return this.code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getParam() {
        return this.param;
    }

    public String getLogID() {
        return this.logID;
    }

    @Override
    public String toString() {
        return "CozeAuthException(statusCode=" + this.getStatusCode() + ", code=" + this.getCode() + ", errorMessage=" + this.getErrorMessage() + ", param=" + this.getParam() + ", logID=" + this.getLogID() + ")";
    }
}

