/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.common;

import com.coze.openapi.client.common.BaseResp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.ResponseBody;

public class FileResponse
extends BaseResp {
    private final ResponseBody response;

    public FileResponse(ResponseBody response) {
        this.response = response;
    }

    public void writeToFile(String filePath) throws IOException {
        File file = new File(filePath);
        try (InputStream inputStream = this.response.byteStream();
             FileOutputStream outputStream = new FileOutputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
    }

    protected FileResponse(FileResponseBuilder<?, ?> b) {
        super(b);
        this.response = ((FileResponseBuilder)b).response;
    }

    public static FileResponseBuilder<?, ?> builder() {
        return new FileResponseBuilderImpl();
    }

    public ResponseBody getResponse() {
        return this.response;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileResponse)) {
            return false;
        }
        FileResponse other = (FileResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResponseBody this$response = this.getResponse();
        ResponseBody other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !this$response.equals(other$response));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ResponseBody $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FileResponse(super=" + super.toString() + ", response=" + this.getResponse() + ")";
    }

    public static abstract class FileResponseBuilder<C extends FileResponse, B extends FileResponseBuilder<C, B>>
    extends BaseResp.BaseRespBuilder<C, B> {
        private ResponseBody response;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B response(ResponseBody response) {
            this.response = response;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FileResponse.FileResponseBuilder(super=" + super.toString() + ", response=" + this.response + ")";
        }
    }

    private static final class FileResponseBuilderImpl
    extends FileResponseBuilder<FileResponse, FileResponseBuilderImpl> {
        private FileResponseBuilderImpl() {
        }

        @Override
        protected FileResponseBuilderImpl self() {
            return this;
        }

        @Override
        public FileResponse build() {
            return new FileResponse(this);
        }
    }
}

