/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.fleece.Encodable;
import com.couchbase.litecore.fleece.Encoder;
import com.couchbase.litecore.fleece.FLValue;
import com.couchbase.litecore.fleece.MCollection;
import java.util.concurrent.atomic.AtomicBoolean;

public class MValue
implements Encodable {
    private static Delegate _delegate;
    public static final MValue EMPTY;
    private boolean _isEmpty;
    private Object _nativeObject;
    private FLValue _value;

    public static void registerDelegate(Delegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate cannot be null.");
        }
        _delegate = delegate;
    }

    public MValue(boolean isEmpty) {
        this._isEmpty = isEmpty;
    }

    public MValue(Object value) {
        this._nativeObject = value;
    }

    public MValue(FLValue value) {
        this._value = value;
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }

    public boolean isMutated() {
        return this._value == null;
    }

    public FLValue getValue() {
        return this._value;
    }

    public Object asNative(MCollection parent) {
        if (this._nativeObject != null || this._value == null) {
            return this._nativeObject;
        }
        AtomicBoolean cacheIt = new AtomicBoolean(false);
        Object obj = this.toNative(this, parent, cacheIt);
        if (cacheIt.get()) {
            this._nativeObject = obj;
        }
        return obj;
    }

    public void mutate() {
        if (this._nativeObject == null) {
            throw new IllegalStateException("Native object is null.");
        }
        this._value = null;
    }

    private static void checkDelegate() {
        if (_delegate == null) {
            throw new IllegalStateException("No MValue delegation defined");
        }
    }

    private Object toNative(MValue mv, MCollection parent, AtomicBoolean cacheIt) {
        MValue.checkDelegate();
        return _delegate.toNative(mv, parent, cacheIt);
    }

    private MCollection collectionFromNative(Object obj) {
        MValue.checkDelegate();
        return _delegate.collectionFromNative(obj);
    }

    private void encodeNative(Encoder encoder, Object object) {
        MValue.checkDelegate();
        _delegate.encodeNative(encoder, object);
    }

    private void nativeChangeSlot(MValue newSlot) {
        MCollection collection = this.collectionFromNative(newSlot);
        if (collection != null) {
            collection.setSlot(newSlot, this);
        }
    }

    protected void finalize() throws Throwable {
        this.nativeChangeSlot(null);
        super.finalize();
    }

    @Override
    public void encodeTo(Encoder enc) {
        if (this._isEmpty) {
            throw new IllegalStateException("MValue is empty.");
        }
        if (this._value != null) {
            enc.writeValue(this._value);
        } else {
            this.encodeNative(enc, this._nativeObject);
        }
    }

    static {
        EMPTY = new MValue(true);
    }

    public static interface Delegate {
        public Object toNative(MValue var1, MCollection var2, AtomicBoolean var3);

        public MCollection collectionFromNative(Object var1);

        public void encodeNative(Encoder var1, Object var2);
    }
}

