/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore.fleece;

import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLSliceResult;
import java.util.List;
import java.util.Map;

public class FLEncoder {
    long _handle = 0L;
    boolean _managed = false;

    public FLEncoder() {
        this(FLEncoder.init());
    }

    public FLEncoder(long handle) {
        this(handle, false);
    }

    public FLEncoder(long handle, boolean managed) {
        this._managed = managed;
        this._handle = handle;
    }

    public void free() {
        if (this._handle != 0L && !this._managed) {
            FLEncoder.free(this._handle);
            this._handle = 0L;
        }
    }

    public boolean writeString(String value) {
        return FLEncoder.writeString(this._handle, value);
    }

    public boolean writeData(byte[] value) {
        return FLEncoder.writeData(this._handle, value);
    }

    public boolean beginDict(long reserve) {
        return FLEncoder.beginDict(this._handle, reserve);
    }

    public boolean endDict() {
        return FLEncoder.endDict(this._handle);
    }

    public boolean beginArray(long reserve) {
        return FLEncoder.beginArray(this._handle, reserve);
    }

    public boolean endArray() {
        return FLEncoder.endArray(this._handle);
    }

    public boolean writeKey(String slice) {
        return FLEncoder.writeKey(this._handle, slice);
    }

    public boolean writeValue(Object value) {
        if (value == null) {
            return FLEncoder.writeNull(this._handle);
        }
        if (value instanceof Boolean) {
            return FLEncoder.writeBool(this._handle, (Boolean)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return FLEncoder.writeInt(this._handle, ((Integer)value).longValue());
            }
            if (value instanceof Long) {
                return FLEncoder.writeInt(this._handle, (Long)value);
            }
            if (value instanceof Short) {
                return FLEncoder.writeInt(this._handle, ((Short)value).longValue());
            }
            if (value instanceof Double) {
                return FLEncoder.writeDouble(this._handle, (Double)value);
            }
            return FLEncoder.writeFloat(this._handle, ((Float)value).floatValue());
        }
        if (value instanceof String) {
            return FLEncoder.writeString(this._handle, (String)value);
        }
        if (value instanceof byte[]) {
            return FLEncoder.writeData(this._handle, (byte[])value);
        }
        if (value instanceof List) {
            return this.write((List)value);
        }
        if (value instanceof Map) {
            return this.write((Map)value);
        }
        return false;
    }

    public boolean write(Map map) {
        this.beginDict(map.size());
        for (String key : map.keySet()) {
            this.writeKey(key);
            this.writeValue(map.get(key));
        }
        return this.endDict();
    }

    public boolean write(List list) {
        this.beginArray(list.size());
        for (Object item : list) {
            this.writeValue(item);
        }
        return this.endArray();
    }

    public byte[] finish() throws LiteCoreException {
        return FLEncoder.finish(this._handle);
    }

    public FLSliceResult finish2() throws LiteCoreException {
        return new FLSliceResult(FLEncoder.finish2(this._handle));
    }

    public void setExtraInfo(Object info) {
        FLEncoder.setExtraInfo(this._handle, info);
    }

    public Object getExtraInfo() {
        return FLEncoder.getExtraInfo(this._handle);
    }

    public void reset() {
        FLEncoder.reset(this._handle);
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    static native long init();

    static native void free(long var0);

    static native boolean writeNull(long var0);

    static native boolean writeBool(long var0, boolean var2);

    static native boolean writeInt(long var0, long var2);

    static native boolean writeFloat(long var0, float var2);

    static native boolean writeDouble(long var0, double var2);

    static native boolean writeString(long var0, String var2);

    static native boolean writeData(long var0, byte[] var2);

    static native boolean beginArray(long var0, long var2);

    static native boolean endArray(long var0);

    static native boolean beginDict(long var0, long var2);

    static native boolean endDict(long var0);

    static native boolean writeKey(long var0, String var2);

    static native byte[] finish(long var0) throws LiteCoreException;

    static native long finish2(long var0) throws LiteCoreException;

    static native void setExtraInfo(long var0, Object var2);

    static native Object getExtraInfo(long var0);

    static native void reset(long var0);
}

