/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.litecore;

import com.couchbase.litecore.C4Error;

public class C4ReplicatorStatus {
    private int activityLevel = -1;
    private long progressUnitsCompleted = 0L;
    private long progressUnitsTotal = 0L;
    private long progressDocumentCount = 0L;
    private int errorDomain = 0;
    private int errorCode = 0;
    private int errorInternalInfo = 0;

    public C4ReplicatorStatus() {
    }

    public C4ReplicatorStatus(int activityLevel) {
        this.activityLevel = activityLevel;
    }

    public C4ReplicatorStatus(int activityLevel, int errorDomain, int errorCode) {
        this.activityLevel = activityLevel;
        this.errorDomain = errorDomain;
        this.errorCode = errorCode;
    }

    public C4ReplicatorStatus(int activityLevel, long progressUnitsCompleted, long progressUnitsTotal, long progressDocumentCount, int errorDomain, int errorCode, int errorInternalInfo) {
        this.activityLevel = activityLevel;
        this.progressUnitsCompleted = progressUnitsCompleted;
        this.progressUnitsTotal = progressUnitsTotal;
        this.progressDocumentCount = progressDocumentCount;
        this.errorDomain = errorDomain;
        this.errorCode = errorCode;
        this.errorInternalInfo = errorInternalInfo;
    }

    public int getActivityLevel() {
        return this.activityLevel;
    }

    public void setActivityLevel(int activityLevel) {
        this.activityLevel = activityLevel;
    }

    public long getProgressUnitsCompleted() {
        return this.progressUnitsCompleted;
    }

    public long getProgressUnitsTotal() {
        return this.progressUnitsTotal;
    }

    public long getProgressDocumentCount() {
        return this.progressDocumentCount;
    }

    public int getErrorDomain() {
        return this.errorDomain;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorInternalInfo() {
        return this.errorInternalInfo;
    }

    public C4Error getC4Error() {
        return new C4Error(this.errorDomain, this.errorCode, this.errorInternalInfo);
    }

    public String toString() {
        return "C4ReplicatorStatus{activityLevel=" + this.activityLevel + ", progressUnitsCompleted=" + this.progressUnitsCompleted + ", progressUnitsTotal=" + this.progressUnitsTotal + ", progressDocumentCount=" + this.progressDocumentCount + ", errorDomain=" + this.errorDomain + ", errorCode=" + this.errorCode + ", errorInternalInfo=" + this.errorInternalInfo + '}';
    }

    public C4ReplicatorStatus copy() {
        return new C4ReplicatorStatus(this.activityLevel, this.progressUnitsCompleted, this.progressUnitsTotal, this.progressDocumentCount, this.errorDomain, this.errorCode, this.errorInternalInfo);
    }

    public static interface C4ReplicatorActivityLevel {
        public static final int kC4Stopped = 0;
        public static final int kC4Offline = 1;
        public static final int kC4Connecting = 2;
        public static final int kC4Idle = 3;
        public static final int kC4Busy = 4;
    }
}

