/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import android.os.Build;
import android.system.ErrnoException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.C4Socket;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.tls.CustomHostnameVerifier;
import okio.Buffer;
import okio.ByteString;

public final class CBLWebSocket
extends C4Socket {
    private static final LogDomain TAG = LogDomain.NETWORK;
    private static final int ECONNRESET = 104;
    private static final int ECONNREFUSED = 111;
    private URI uri = null;
    private Map<String, Object> options;
    private WebSocket webSocket = null;
    OkHttpClient httpClient = null;
    CBLWebSocketListener wsListener = null;

    CBLWebSocket(long handle, String scheme, String hostname, int port, String path, Map<String, Object> options) throws GeneralSecurityException, URISyntaxException {
        super(handle);
        this.uri = new URI(this.checkScheme(scheme), null, hostname, port, path, null, null);
        this.options = options;
        this.httpClient = this.setupOkHttpClient();
        this.wsListener = new CBLWebSocketListener();
    }

    @Override
    protected void send(byte[] allocatedData) {
        if (this.webSocket.send(ByteString.of((byte[])allocatedData, (int)0, (int)allocatedData.length))) {
            this.completedWrite(allocatedData.length);
        } else {
            Log.e(TAG, "CBLWebSocket.send() FAILED to send data");
        }
    }

    @Override
    protected void completedReceive(long byteCount) {
    }

    @Override
    protected void close() {
    }

    @Override
    protected void requestClose(int status, String message) {
        if (this.webSocket == null) {
            Log.w(TAG, "CBLWebSocket.requestClose() webSocket is not initialized.");
            return;
        }
        if (!this.webSocket.close(status, message)) {
            Log.w(TAG, "CBLWebSocket.requestClose() Failed to attempt to initiate a graceful shutdown of this web socket.");
        }
    }

    public static void socket_open(long socket, Object socketFactoryContext, String scheme, String hostname, int port, String path, byte[] optionsFleece) {
        CBLWebSocket c4sock;
        Log.e(TAG, "CBLWebSocket.socket_open()");
        Map<String, Object> options = null;
        if (optionsFleece != null) {
            options = FLValue.fromData(optionsFleece).asDict();
        }
        if (scheme.equalsIgnoreCase("blip")) {
            scheme = "ws";
        } else if (scheme.equalsIgnoreCase("blips")) {
            scheme = "wss";
        }
        try {
            c4sock = new CBLWebSocket(socket, scheme, hostname, port, path, options);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to instantiate C4Socket: " + e);
            e.printStackTrace();
            return;
        }
        reverseLookupTable.put(socket, c4sock);
        c4sock.start();
    }

    protected void start() {
        Log.v(TAG, String.format(Locale.ENGLISH, "CBLWebSocket connecting to %s...", this.uri));
        this.httpClient.newWebSocket(this.newRequest(), (WebSocketListener)this.wsListener);
    }

    private OkHttpClient setupOkHttpClient() throws GeneralSecurityException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS);
        builder.followRedirects(true).followSslRedirects(true);
        Authenticator authenticator = this.setupAuthenticator();
        if (authenticator != null) {
            builder.authenticator(authenticator);
        }
        this.setupSSLSocketFactory(builder);
        return builder.build();
    }

    private Authenticator setupAuthenticator() {
        Map auth;
        if (this.options != null && this.options.containsKey("auth") && (auth = (Map)this.options.get("auth")) != null) {
            final String username = (String)auth.get("username");
            final String password = (String)auth.get("password");
            if (username != null && password != null) {
                return new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        Log.v(TAG, "Authenticating for response: " + response);
                        if (CBLWebSocket.this.responseCount(response) >= 3) {
                            return null;
                        }
                        List challenges = response.challenges();
                        Log.v(TAG, "Challenges: " + challenges);
                        if (challenges != null) {
                            for (Challenge challenge : challenges) {
                                if (!challenge.scheme().equals("Basic")) continue;
                                String credential = Credentials.basic((String)username, (String)password);
                                return response.request().newBuilder().header("Authorization", credential).build();
                            }
                        }
                        return null;
                    }
                };
            }
        }
        return null;
    }

    private InputStream toStream(byte[] pin) {
        return new Buffer().write(pin).inputStream();
    }

    private int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    private Request newRequest() {
        String protocols;
        Request.Builder builder = new Request.Builder();
        builder.url(this.uri.toString());
        String host = this.uri.getHost();
        if (this.uri.getPort() != -1) {
            host = String.format(Locale.ENGLISH, "%s:%d", host, this.uri.getPort());
        }
        builder.header("Host", host);
        if (this.options != null) {
            String cookieString;
            Map extraHeaders = (Map)this.options.get("headers");
            if (extraHeaders != null) {
                for (Map.Entry entry : extraHeaders.entrySet()) {
                    builder.header((String)entry.getKey(), entry.getValue().toString());
                }
            }
            if ((cookieString = (String)this.options.get("cookies")) != null) {
                builder.addHeader("Cookie", cookieString);
            }
        }
        if ((protocols = (String)this.options.get("WS-Protocols")) != null) {
            builder.header("Sec-WebSocket-Protocol", protocols);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedHTTPResponse(Response response) {
        int httpStatus = response.code();
        Log.v(TAG, "receivedHTTPResponse() httpStatus -> " + httpStatus);
        Headers hs = response.headers();
        if (hs != null && hs.size() > 0) {
            byte[] headersFleece = null;
            HashMap<String, String> headers = new HashMap<String, String>();
            for (int i = 0; i < hs.size(); ++i) {
                headers.put(hs.name(i), hs.value(i));
            }
            FLEncoder enc = new FLEncoder();
            enc.write(headers);
            try {
                headersFleece = enc.finish();
            }
            catch (LiteCoreException e) {
                Log.e(TAG, "Failed to encode", e);
            }
            finally {
                enc.free();
            }
            this.gotHTTPResponse(httpStatus, headersFleece);
        }
    }

    private void didClose(int code, String reason) {
        if (code == 1000) {
            this.didClose(null);
            return;
        }
        Log.i(TAG, "CBLWebSocket CLOSED WITH STATUS " + code + " \"" + reason + "\"");
        CBLWebSocket.closed(this.handle, 6, code, reason);
    }

    private void didClose(Throwable error) {
        if (error == null) {
            CBLWebSocket.closed(this.handle, 6, 0, null);
        } else if (Build.VERSION.SDK_INT >= 21 && error.getCause() != null && error.getCause().getCause() != null && error.getCause().getCause() instanceof ErrnoException) {
            ErrnoException e = (ErrnoException)error.getCause().getCause();
            CBLWebSocket.closed(this.handle, 2, e != null ? e.errno : 0, null);
        } else if (error.getCause() != null && error.getCause() instanceof CertificateException) {
            CBLWebSocket.closed(this.handle, 5, 8, null);
        } else if (error instanceof SSLPeerUnverifiedException) {
            CBLWebSocket.closed(this.handle, 5, 8, null);
        } else if (error instanceof ConnectException) {
            CBLWebSocket.closed(this.handle, 2, 111, null);
        } else if (error instanceof SocketException) {
            CBLWebSocket.closed(this.handle, 2, 104, null);
        } else if (error instanceof EOFException) {
            CBLWebSocket.closed(this.handle, 2, 104, null);
        } else if (error instanceof UnknownHostException) {
            CBLWebSocket.closed(this.handle, 5, 2, null);
        } else {
            CBLWebSocket.closed(this.handle, 6, 0, null);
        }
    }

    private String checkScheme(String scheme) {
        if (scheme.equalsIgnoreCase("blip")) {
            return "ws";
        }
        if (scheme.equalsIgnoreCase("blips")) {
            return "wss";
        }
        return scheme;
    }

    private void setupSSLSocketFactory(OkHttpClient.Builder builder) throws GeneralSecurityException {
        byte[] pin;
        boolean isPinningServerCert = false;
        X509TrustManager trustManager = null;
        if (this.options != null && this.options.containsKey("pinnedCert") && (pin = (byte[])this.options.get("pinnedCert")) != null) {
            trustManager = this.trustManagerForCertificates(this.toStream(pin));
            isPinningServerCert = true;
        }
        if (trustManager == null) {
            trustManager = this.defaultTrustManager();
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        TLSSocketFactory sslSocketFactory = new TLSSocketFactory(null, new TrustManager[]{trustManager}, null);
        builder.sslSocketFactory((SSLSocketFactory)sslSocketFactory, trustManager);
        if (isPinningServerCert) {
            builder.hostnameVerifier((HostnameVerifier)CustomHostnameVerifier.getInstance());
        }
    }

    private X509TrustManager defaultTrustManager() throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length == 0) {
            throw new IllegalStateException("Cannot find the default trust manager");
        }
        return (X509TrustManager)trustManagers[0];
    }

    private X509TrustManager trustManagerForCertificates(InputStream in) throws GeneralSecurityException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("expected non-empty set of trusted certificates");
        }
        char[] password = "umwxnikwxx".toCharArray();
        KeyStore keyStore = this.newEmptyKeyStore(password);
        int index = 0;
        for (Certificate certificate : certificates) {
            String certificateAlias = Integer.toString(index++);
            keyStore.setCertificateEntry(certificateAlias, certificate);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class TLSSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory delegate;

        public TLSSocketFactory(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws GeneralSecurityException {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, secureRandom);
            this.delegate = context.getSocketFactory();
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.setEnabledProtocols(this.delegate.createSocket(socket, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.setEnabledProtocols(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.setEnabledProtocols(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port) throws IOException {
            return this.setEnabledProtocols(this.delegate.createSocket(address, port));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.setEnabledProtocols(this.delegate.createSocket(inetAddress, port, localAddress, localPort));
        }

        private Socket setEnabledProtocols(Socket socket) {
            if (socket != null && socket instanceof SSLSocket) {
                ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
            return socket;
        }
    }

    class CBLWebSocketListener
    extends WebSocketListener {
        CBLWebSocketListener() {
        }

        public void onOpen(WebSocket webSocket, Response response) {
            Log.v(TAG, "WebSocketListener.onOpen() response -> " + response);
            CBLWebSocket.this.webSocket = webSocket;
            CBLWebSocket.this.receivedHTTPResponse(response);
            Log.i(TAG, "CBLWebSocket CONNECTED!");
            CBLWebSocket.opened(CBLWebSocket.this.handle);
        }

        public void onMessage(WebSocket webSocket, String text) {
            Log.v(TAG, "WebSocketListener.onMessage() text -> " + text);
            CBLWebSocket.received(CBLWebSocket.this.handle, text.getBytes());
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            Log.v(TAG, "WebSocketListener.onMessage() bytes -> " + bytes.hex());
            CBLWebSocket.received(CBLWebSocket.this.handle, bytes.toByteArray());
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            Log.v(TAG, "WebSocketListener.onClosing() code -> " + code + ", reason -> " + reason);
            CBLWebSocket.closeRequested(CBLWebSocket.this.handle, code, reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            Log.v(TAG, "WebSocketListener.onClosed() code -> " + code + ", reason -> " + reason);
            CBLWebSocket.this.didClose(code, reason);
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            Log.w(TAG, "WebSocketListener.onFailure() response -> " + response, t);
            if (response != null) {
                int httpStatus = response.code();
                if (httpStatus != 101) {
                    int closeCode = 1008;
                    if (httpStatus >= 300 && httpStatus < 1000) {
                        closeCode = httpStatus;
                    }
                    CBLWebSocket.this.didClose(closeCode, response.message());
                } else {
                    CBLWebSocket.this.didClose(1002, response.message());
                }
            } else {
                CBLWebSocket.this.didClose(t);
            }
        }
    }
}

