/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Endpoint;
import java.net.URI;
import java.util.Locale;

public final class URLEndpoint
implements Endpoint {
    static final String kURLEndpointScheme = "ws";
    static final String kURLEndpointTLSScheme = "wss";
    private final URI url;

    public URLEndpoint(@NonNull URI url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        String scheme = url.getScheme();
        if (!kURLEndpointScheme.equals(scheme) && !kURLEndpointTLSScheme.equals(scheme)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid scheme for URLEndpoint url (%s); must be either %s or %s.", scheme, kURLEndpointScheme, kURLEndpointTLSScheme));
        }
        String userInfo = url.getUserInfo();
        if (userInfo != null && userInfo.split(":").length == 2) {
            throw new IllegalArgumentException("Embedded credentials in a URL (username:password@url) are not allowed; use the BasicAuthenticator class instead.");
        }
        this.url = url;
    }

    @NonNull
    public String toString() {
        return "URLEndpoint{url=" + this.url + '}';
    }

    @NonNull
    public URI getURL() {
        return this.url;
    }
}

