/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.ArrayInterface;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.internal.utils.DateUtils;
import com.couchbase.litecore.C4QueryEnumerator;
import com.couchbase.litecore.fleece.FLArrayIterator;
import com.couchbase.litecore.fleece.FLValue;
import com.couchbase.litecore.fleece.MContext;
import com.couchbase.litecore.fleece.MRoot;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Result
implements ArrayInterface,
DictionaryInterface,
Iterable<String> {
    private ResultSet rs;
    private List<FLValue> values;
    private long missingColumns;
    private MContext context;

    Result(ResultSet rs, C4QueryEnumerator c4enum, MContext context) {
        this.rs = rs;
        this.values = this.extractColumns(c4enum.getColumns());
        this.missingColumns = c4enum.getMissingColumns();
        this.context = context;
    }

    @Override
    public int count() {
        return this.rs.columnCount();
    }

    @Override
    public Object getValue(int index) {
        this.check(index);
        return this.fleeceValueToObject(index);
    }

    @Override
    public String getString(int index) {
        this.check(index);
        Object obj = this.fleeceValueToObject(index);
        return obj instanceof String ? (String)obj : null;
    }

    @Override
    public Number getNumber(int index) {
        this.check(index);
        return CBLConverter.asNumber(this.fleeceValueToObject(index));
    }

    @Override
    public int getInt(int index) {
        this.check(index);
        FLValue flValue = this.values.get(index);
        return flValue != null ? (int)flValue.asInt() : 0;
    }

    @Override
    public long getLong(int index) {
        this.check(index);
        FLValue flValue = this.values.get(index);
        return flValue != null ? flValue.asInt() : 0L;
    }

    @Override
    public float getFloat(int index) {
        this.check(index);
        FLValue flValue = this.values.get(index);
        return flValue != null ? flValue.asFloat() : 0.0f;
    }

    @Override
    public double getDouble(int index) {
        this.check(index);
        FLValue flValue = this.values.get(index);
        return flValue != null ? flValue.asDouble() : 0.0;
    }

    @Override
    public boolean getBoolean(int index) {
        this.check(index);
        FLValue flValue = this.values.get(index);
        return flValue != null ? flValue.asBool() : false;
    }

    @Override
    public Blob getBlob(int index) {
        this.check(index);
        Object obj = this.fleeceValueToObject(index);
        return obj instanceof Blob ? (Blob)obj : null;
    }

    @Override
    public Date getDate(int index) {
        this.check(index);
        return DateUtils.fromJson(this.getString(index));
    }

    @Override
    public Array getArray(int index) {
        this.check(index);
        Object obj = this.fleeceValueToObject(index);
        return obj instanceof Array ? (Array)obj : null;
    }

    @Override
    public Dictionary getDictionary(int index) {
        this.check(index);
        Object obj = this.fleeceValueToObject(index);
        return obj instanceof Dictionary ? (Dictionary)obj : null;
    }

    @Override
    @NonNull
    public List<Object> toList() {
        ArrayList<Object> array = new ArrayList<Object>();
        for (int i = 0; i < this.count(); ++i) {
            FLValue value = this.values.get(i);
            array.add(value.asObject());
        }
        return array;
    }

    @Override
    @NonNull
    public List<String> getKeys() {
        return new ArrayList<String>(this.rs.getColumnNames().keySet());
    }

    @Override
    public Object getValue(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getValue(index) : null;
    }

    @Override
    public String getString(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getString(index) : null;
    }

    @Override
    public Number getNumber(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? (Number)this.getNumber(index) : (Number)null;
    }

    @Override
    public int getInt(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getInt(index) : 0;
    }

    @Override
    public long getLong(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getLong(index) : 0L;
    }

    @Override
    public float getFloat(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getFloat(index) : 0.0f;
    }

    @Override
    public double getDouble(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getDouble(index) : 0.0;
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getBoolean(index) : false;
    }

    @Override
    public Blob getBlob(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getBlob(index) : null;
    }

    @Override
    public Date getDate(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getDate(index) : null;
    }

    @Override
    public Array getArray(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getArray(index) : null;
    }

    @Override
    public Dictionary getDictionary(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        int index = this.indexForColumnName(key);
        return index >= 0 ? this.getDictionary(index) : null;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        List<Object> values = this.toList();
        HashMap<String, Object> dict = new HashMap<String, Object>();
        for (String name : this.rs.getColumnNames().keySet()) {
            int index = this.indexForColumnName(name);
            if (index < 0) continue;
            dict.put(name, values.get(index));
        }
        return dict;
    }

    @Override
    public boolean contains(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        return this.indexForColumnName(key) >= 0;
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    private int indexForColumnName(String name) {
        Integer index = this.rs.getColumnNames().get(name);
        if (index == null) {
            return -1;
        }
        boolean hasValue = (this.missingColumns & (long)(1 << index)) == 0L;
        return hasValue ? index : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fleeceValueToObject(int index) {
        this.check(index);
        FLValue value = this.values.get(index);
        if (value == null) {
            return null;
        }
        MRoot root = new MRoot(this.context, value, false);
        Object object = this.rs.getQuery().getDatabase().getLock();
        synchronized (object) {
            return root.asNative();
        }
    }

    List<FLValue> extractColumns(FLArrayIterator columns) {
        int count = this.rs.getColumnNames().size();
        ArrayList<FLValue> values = new ArrayList<FLValue>();
        for (int i = 0; i < count; ++i) {
            values.add(columns.getValueAt(i));
        }
        return values;
    }

    private void check(int index) {
        if (index < 0 || index >= this.count()) {
            String msg = String.format(Locale.ENGLISH, "length=%d; index=%d", this.count(), index);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }
}

