/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DocumentFlag;
import com.couchbase.litecore.C4Error;
import java.util.EnumSet;

public final class ReplicatedDocument {
    private EnumSet<DocumentFlag> documentFlags;
    private String id = "";
    private C4Error error;
    private boolean trans;

    ReplicatedDocument(String id, int flags, C4Error error, boolean trans) {
        this.id = id;
        this.error = error;
        this.trans = trans;
        this.documentFlags = EnumSet.noneOf(DocumentFlag.class);
        if ((flags & 1) == 1) {
            this.documentFlags.add(DocumentFlag.DocumentFlagsDeleted);
        }
        if ((flags & 0x80) == 128) {
            this.documentFlags.add(DocumentFlag.DocumentFlagsAccessRemoved);
        }
    }

    @NonNull
    public String getID() {
        return this.id;
    }

    @NonNull
    public EnumSet<DocumentFlag> flags() {
        return this.documentFlags;
    }

    public CouchbaseLiteException getError() {
        return this.error.getCode() != 0 ? CBLStatus.convertError(this.error) : null;
    }

    @NonNull
    public String toString() {
        return "ReplicatedDocument {, document id =" + this.id + ", error code =" + this.error.getCode() + ", error domain=" + this.error.getDomain() + '}';
    }
}

