/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.ArrayList;

public final class PropertyExpression
extends Expression {
    static final String kCBLAllPropertiesName = "";
    private final String keyPath;
    private String columnName;
    private final String from;

    PropertyExpression(String keyPath) {
        this.keyPath = keyPath;
        this.from = null;
    }

    private PropertyExpression(String keyPath, String from) {
        this.keyPath = keyPath;
        this.from = from;
    }

    private PropertyExpression(String keyPath, String columnName, String from) {
        this.keyPath = keyPath;
        this.columnName = columnName;
        this.from = from;
    }

    @NonNull
    public Expression from(String alias) {
        return new PropertyExpression(this.keyPath, alias);
    }

    static PropertyExpression allFrom(String from) {
        String colName = from != null ? from : kCBLAllPropertiesName;
        return new PropertyExpression(kCBLAllPropertiesName, colName, from);
    }

    @Override
    Object asJSON() {
        ArrayList<String> json = new ArrayList<String>();
        if (this.from != null) {
            json.add("." + this.from + "." + this.keyPath);
        } else {
            json.add("." + this.keyPath);
        }
        return json;
    }

    String getColumnName() {
        if (this.columnName == null) {
            String[] pathes = this.keyPath.split("\\.");
            this.columnName = pathes[pathes.length - 1];
        }
        return this.columnName;
    }
}

