/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.NetworkReachabilityListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class NetworkReachabilityManager {
    private Set<NetworkReachabilityListener> listeners = Collections.synchronizedSet(new HashSet());

    NetworkReachabilityManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNetworkReachabilityListener(NetworkReachabilityListener listener) {
        Set<NetworkReachabilityListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            if (this.listeners.size() == 1) {
                this.startListening();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNetworkReachabilityListener(NetworkReachabilityListener listener) {
        Set<NetworkReachabilityListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.stopListening();
            }
        }
    }

    void notifyListenersNetworkReachable() {
        HashSet<NetworkReachabilityListener> copy = new HashSet<NetworkReachabilityListener>(this.listeners);
        for (NetworkReachabilityListener listener : copy) {
            if (listener == null) continue;
            listener.networkReachable();
        }
    }

    void notifyListenersNetworkUneachable() {
        HashSet<NetworkReachabilityListener> copy = new HashSet<NetworkReachabilityListener>(this.listeners);
        for (NetworkReachabilityListener listener : copy) {
            if (listener == null) continue;
            listener.networkUnreachable();
        }
    }

    abstract void startListening();

    abstract void stopListening();
}

