/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Document;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.MutableDictionaryInterface;
import com.couchbase.litecore.C4Constants;
import com.couchbase.litecore.C4Document;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class MutableDocument
extends Document
implements MutableDictionaryInterface,
C4Constants {
    public MutableDocument() {
        this((String)null);
    }

    public MutableDocument(String id) {
        super(null, id != null ? id : MutableDocument.createUUID(), (C4Document)null);
    }

    public MutableDocument(Map<String, Object> data) {
        this((String)null);
        this.setData((Map)data);
    }

    public MutableDocument(String id, Map<String, Object> data) {
        this(id);
        this.setData((Map)data);
    }

    MutableDocument(Document doc, Dictionary dict) {
        super(doc.getDatabase(), doc.getId(), doc.getC4doc());
        if (dict != null) {
            this._dict = dict.toMutable();
        }
    }

    @Override
    @NonNull
    public MutableDocument toMutable() {
        return new MutableDocument(this, this._dict);
    }

    @Override
    @NonNull
    public MutableDocument setData(Map<String, Object> data) {
        ((MutableDictionary)this._dict).setData((Map)data);
        return this;
    }

    @Override
    @NonNull
    public MutableDocument setValue(@NonNull String key, Object value) {
        ((MutableDictionary)this._dict).setValue(key, value);
        return this;
    }

    @Override
    @NonNull
    public MutableDocument setString(@NonNull String key, String value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setNumber(@NonNull String key, Number value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setInt(@NonNull String key, int value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setLong(@NonNull String key, long value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setFloat(@NonNull String key, float value) {
        return this.setValue(key, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableDocument setDouble(@NonNull String key, double value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setBoolean(@NonNull String key, boolean value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setBlob(@NonNull String key, Blob value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setDate(@NonNull String key, Date value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setArray(@NonNull String key, Array value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument setDictionary(@NonNull String key, Dictionary value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDocument remove(@NonNull String key) {
        ((MutableDictionary)this._dict).remove(key);
        return this;
    }

    @Override
    public MutableArray getArray(@NonNull String key) {
        return ((MutableDictionary)this._dict).getArray(key);
    }

    @Override
    public MutableDictionary getDictionary(@NonNull String key) {
        return ((MutableDictionary)this._dict).getDictionary(key);
    }

    @Override
    boolean isMutable() {
        return true;
    }

    @Override
    long generation() {
        return super.generation() + (long)(this.isChanged() ? 1 : 0);
    }

    boolean isChanged() {
        return ((MutableDictionary)this._dict).isChanged();
    }

    static String createUUID() {
        return UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH);
    }
}

