/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionaryInterface;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MDict;
import com.couchbase.litecore.fleece.MValue;
import java.util.Date;
import java.util.Map;

public final class MutableDictionary
extends Dictionary
implements MutableDictionaryInterface {
    public MutableDictionary() {
    }

    public MutableDictionary(Map<String, Object> data) {
        this.setData((Map)data);
    }

    MutableDictionary(MDict mDict, boolean isMutable) {
        super(mDict, isMutable);
    }

    MutableDictionary(MValue mv, MCollection parent) {
        super(mv, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setData(Map<String, Object> data) {
        Object object = this._sharedLock;
        synchronized (object) {
            this._dict.clear();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                this._dict.set(entry.getKey(), new MValue(Fleece.toCBLObject(entry.getValue())));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setValue(@NonNull String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            MValue oldValue = this._dict.get(key);
            value = Fleece.toCBLObject(value);
            if (Fleece.valueWouldChange(value, oldValue, this._dict)) {
                this._dict.set(key, new MValue(value));
            }
            return this;
        }
    }

    @Override
    @NonNull
    public MutableDictionary setString(@NonNull String key, String value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setNumber(@NonNull String key, Number value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setInt(@NonNull String key, int value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setLong(@NonNull String key, long value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setFloat(@NonNull String key, float value) {
        return this.setValue(key, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableDictionary setDouble(@NonNull String key, double value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setBoolean(@NonNull String key, boolean value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setBlob(@NonNull String key, Blob value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setDate(@NonNull String key, Date value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setArray(@NonNull String key, Array value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setDictionary(@NonNull String key, Dictionary value) {
        return this.setValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary remove(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            this._dict.remove(key);
            return this;
        }
    }

    @Override
    public MutableArray getArray(@NonNull String key) {
        return (MutableArray)super.getArray(key);
    }

    @Override
    public MutableDictionary getDictionary(@NonNull String key) {
        return (MutableDictionary)super.getDictionary(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isChanged() {
        Object object = this._sharedLock;
        synchronized (object) {
            return this._dict.isMutated();
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }
}

