/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableArrayInterface;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.litecore.fleece.MArray;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MValue;
import java.util.Date;
import java.util.List;

public final class MutableArray
extends Array
implements MutableArrayInterface {
    public MutableArray() {
    }

    public MutableArray(List<Object> data) {
        this.setData((List)data);
    }

    MutableArray(MArray mArray, boolean isMutable) {
        super(mArray, isMutable);
    }

    MutableArray(MValue mv, MCollection parent) {
        super(mv, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray setData(List<Object> data) {
        Object object = this._sharedLock;
        synchronized (object) {
            this._array.clear();
            for (Object obj : data) {
                this._array.append(Fleece.toCBLObject(obj));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray setValue(int index, Object value) {
        Object object = this._sharedLock;
        synchronized (object) {
            if (Fleece.valueWouldChange(value, this._array.get(index), this._array) && !this._array.set(index, Fleece.toCBLObject(value))) {
                MutableArray.throwRangeException(index);
            }
            return this;
        }
    }

    @Override
    @NonNull
    public MutableArray setString(int index, String value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setNumber(int index, Number value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setInt(int index, int value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setLong(int index, long value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setFloat(int index, float value) {
        return this.setValue(index, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableArray setDouble(int index, double value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setBoolean(int index, boolean value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setBlob(int index, Blob value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setDate(int index, Date value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setArray(int index, Array value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setDictionary(int index, Dictionary value) {
        return this.setValue(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray addValue(Object value) {
        Object object = this._sharedLock;
        synchronized (object) {
            this._array.append(Fleece.toCBLObject(value));
            return this;
        }
    }

    @Override
    @NonNull
    public MutableArray addString(String value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addNumber(Number value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addInt(int value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addLong(long value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addFloat(float value) {
        return this.addValue(Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableArray addDouble(double value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addBoolean(boolean value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addBlob(Blob value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addDate(Date value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addArray(Array value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addDictionary(Dictionary value) {
        return this.addValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray insertValue(int index, Object value) {
        Object object = this._sharedLock;
        synchronized (object) {
            if (!this._array.insert(index, Fleece.toCBLObject(value))) {
                MutableArray.throwRangeException(index);
            }
            return this;
        }
    }

    @Override
    @NonNull
    public MutableArray insertString(int index, String value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertNumber(int index, Number value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertInt(int index, int value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertLong(int index, long value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertFloat(int index, float value) {
        return this.insertValue(index, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableArray insertDouble(int index, double value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertBoolean(int index, boolean value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertBlob(int index, Blob value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertDate(int index, Date value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertArray(int index, Array value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertDictionary(int index, Dictionary value) {
        return this.insertValue(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray remove(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            if (!this._array.remove(index)) {
                MutableArray.throwRangeException(index);
            }
            return this;
        }
    }

    @Override
    public MutableArray getArray(int index) {
        return (MutableArray)super.getArray(index);
    }

    @Override
    public MutableDictionary getDictionary(int index) {
        return (MutableDictionary)super.getDictionary(index);
    }
}

