/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.ArrayList;

public class MetaExpression
extends Expression {
    private final String keyPath;
    private String columnName;
    private final String from;

    private MetaExpression(String keyPath, String from) {
        this.keyPath = keyPath;
        this.from = from;
    }

    MetaExpression(String keyPath, String columnName, String from) {
        this.keyPath = keyPath;
        this.columnName = columnName;
        this.from = from;
    }

    @NonNull
    public Expression from(@NonNull String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias cannot be null.");
        }
        return new MetaExpression(this.keyPath, alias);
    }

    @Override
    Object asJSON() {
        ArrayList<String> json = new ArrayList<String>();
        if (this.from != null) {
            json.add("." + this.from + "." + this.keyPath);
        } else {
            json.add("." + this.keyPath);
        }
        return json;
    }

    String getColumnName() {
        if (this.columnName == null) {
            String[] pathes = this.keyPath.split("\\.");
            this.columnName = pathes[pathes.length - 1];
        }
        return this.columnName;
    }
}

