/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.Expression;
import com.couchbase.lite.Join;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LimitRouter;
import com.couchbase.lite.OrderBy;
import com.couchbase.lite.OrderByRouter;
import com.couchbase.lite.Ordering;
import com.couchbase.lite.Where;
import com.couchbase.lite.WhereRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Joins
extends AbstractQuery
implements WhereRouter,
OrderByRouter,
LimitRouter {
    private List<Join> joins;

    Joins(AbstractQuery query, List<Join> joins) {
        this.copy(query);
        this.joins = joins;
        this.setJoins(this);
    }

    @Override
    @NonNull
    public Where where(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Where(this, expression);
    }

    @Override
    @NonNull
    public OrderBy orderBy(Ordering ... orderings) {
        if (orderings == null) {
            throw new IllegalArgumentException("orderings cannot be null.");
        }
        return new OrderBy(this, Arrays.asList(orderings));
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit) {
        if (limit == null) {
            throw new IllegalArgumentException("limit cannot be null.");
        }
        return new Limit(this, limit, null);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit, Expression offset) {
        if (limit == null) {
            throw new IllegalArgumentException("limit cannot be null.");
        }
        return new Limit(this, limit, offset);
    }

    Object asJSON() {
        ArrayList<Object> json = new ArrayList<Object>();
        for (Join join : this.joins) {
            json.add(join.asJSON());
        }
        return json;
    }
}

