/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.DataSource;
import com.couchbase.lite.Expression;
import java.util.HashMap;

public class Join {
    static final String kCBLInnerJoin = "INNER";
    static final String kCBLOuterJoin = "OUTER";
    static final String kCBLLeftOuterJoin = "LEFT OUTER";
    static final String kCBLCrossJoin = "CROSS";
    private String type;
    private DataSource dataSource;

    private Join(String type, DataSource dataSource) {
        this.type = type;
        this.dataSource = dataSource;
    }

    @NonNull
    public static On join(@NonNull DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource cannot be null.");
        }
        return Join.innerJoin(datasource);
    }

    @NonNull
    public static On leftJoin(@NonNull DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource cannot be null.");
        }
        return new On(kCBLLeftOuterJoin, datasource);
    }

    @NonNull
    public static On leftOuterJoin(@NonNull DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource cannot be null.");
        }
        return new On(kCBLLeftOuterJoin, datasource);
    }

    @NonNull
    public static On innerJoin(@NonNull DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource cannot be null.");
        }
        return new On(kCBLInnerJoin, datasource);
    }

    @NonNull
    public static Join crossJoin(@NonNull DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource cannot be null.");
        }
        return new Join(kCBLCrossJoin, datasource);
    }

    Object asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("JOIN", this.type);
        json.putAll(this.dataSource.asJSON());
        return json;
    }

    public static final class On
    extends Join {
        private Expression on;

        private On(String type, DataSource datasource) {
            super(type, datasource);
        }

        @NonNull
        public Join on(@NonNull Expression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("expression cannot be null.");
            }
            this.on = expression;
            return this;
        }

        @Override
        Object asJSON() {
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("JOIN", ((Join)this).type);
            json.put("ON", this.on.asJSON());
            json.putAll(((Join)this).dataSource.asJSON());
            return json;
        }
    }
}

