/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.Expression;
import com.couchbase.lite.Having;
import com.couchbase.lite.HavingRouter;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LimitRouter;
import com.couchbase.lite.OrderBy;
import com.couchbase.lite.OrderByRouter;
import com.couchbase.lite.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GroupBy
extends AbstractQuery
implements HavingRouter,
OrderByRouter,
LimitRouter {
    private List<Expression> expressions;

    GroupBy(AbstractQuery query, List<Expression> expressions) {
        this.copy(query);
        this.expressions = expressions;
        this.setGroupBy(this);
    }

    @Override
    @NonNull
    public Having having(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Having(this, expression);
    }

    @Override
    @NonNull
    public OrderBy orderBy(Ordering ... orderings) {
        if (orderings == null) {
            throw new IllegalArgumentException("orderings cannot be null.");
        }
        return new OrderBy(this, Arrays.asList(orderings));
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit) {
        if (limit == null) {
            throw new IllegalArgumentException("limit cannot be null.");
        }
        return new Limit(this, limit, null);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit, Expression offset) {
        if (limit == null) {
            throw new IllegalArgumentException("limit cannot be null.");
        }
        return new Limit(this, limit, offset);
    }

    Object asJSON() {
        ArrayList<Object> groupBy = new ArrayList<Object>();
        for (Expression expression : this.expressions) {
            groupBy.add(expression.asJSON());
        }
        return groupBy;
    }
}

