/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractFunction;
import com.couchbase.lite.Expression;
import com.couchbase.lite.PredictionFunction;
import java.util.Arrays;

public final class Function
extends AbstractFunction {
    @NonNull
    public static PredictionFunction prediction(@NonNull String model, @NonNull Expression input) {
        return new PredictionFunction(model, input);
    }

    @NonNull
    public static Expression euclideanDistance(@NonNull Expression expression1, @NonNull Expression expression2) {
        if (expression1 == null) {
            throw new IllegalArgumentException("expression1 cannot be null.");
        }
        if (expression2 == null) {
            throw new IllegalArgumentException("expression2 cannot be null.");
        }
        return new Expression.FunctionExpression("EUCLIDEAN_DISTANCE()", Arrays.asList(expression1, expression2));
    }

    @NonNull
    public static Expression squaredEuclideanDistance(@NonNull Expression expression1, @NonNull Expression expression2) {
        if (expression1 == null) {
            throw new IllegalArgumentException("expression1 cannot be null.");
        }
        if (expression2 == null) {
            throw new IllegalArgumentException("expression2 cannot be null.");
        }
        return new Expression.FunctionExpression("EUCLIDEAN_DISTANCE()", Arrays.asList(expression1, expression2, Expression.intValue(2)));
    }

    @NonNull
    public static Expression cosineDistance(@NonNull Expression expression1, @NonNull Expression expression2) {
        if (expression1 == null) {
            throw new IllegalArgumentException("expression1 cannot be null.");
        }
        if (expression2 == null) {
            throw new IllegalArgumentException("expression2 cannot be null.");
        }
        return new Expression.FunctionExpression("COSINE_DISTANCE()", Arrays.asList(expression1, expression2));
    }
}

