/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.CBLVersion;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogFileConfiguration;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.C4Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class FileLogger
implements Logger {
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    private LogLevel _level = LogLevel.INFO;
    private LogFileConfiguration _config;
    private final HashMap<LogDomain, String> _domainObjects = new HashMap();

    FileLogger() {
        this.setupDomainObjects();
    }

    public LogFileConfiguration getConfig() {
        return this._config;
    }

    public void setConfig(LogFileConfiguration config) {
        LogFileConfiguration logFileConfiguration = this._config = config == null ? null : config.readOnlyCopy();
        if (config == null) {
            Log.w(DOMAIN, "Database.log.getFile().getConfig() is now null, meaning file logging is disabled.  Log files required for product support are not being generated.");
        }
        this.updateConfig();
    }

    public void setLevel(@NonNull LogLevel level) {
        if (this._config == null) {
            throw new IllegalStateException("Cannot set logging level without a configuration");
        }
        if (this._level.equals((Object)level)) {
            return;
        }
        this._level = level;
        C4Log.setBinaryFileLevel(level.getValue());
    }

    private void setupDomainObjects() {
        this._domainObjects.put(LogDomain.DATABASE, "DB");
        this._domainObjects.put(LogDomain.QUERY, "Query");
        this._domainObjects.put(LogDomain.REPLICATOR, "Sync");
        for (Map.Entry<LogDomain, String> entry : this._domainObjects.entrySet()) {
            C4Log.setLevel(entry.getValue(), 0);
        }
    }

    private void updateConfig() {
        if (this._config != null) {
            new File(this._config.getDirectory()).mkdir();
            C4Log.writeToBinaryFile(this._config.getDirectory(), this._level.getValue(), this._config.getMaxRotateCount(), this._config.getMaxSize(), this._config.usesPlaintext(), CBLVersion.getUserAgent());
        } else {
            C4Log.writeToBinaryFile(null, this._level.getValue(), 1, 512000L, false, CBLVersion.getUserAgent());
        }
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        return LogLevel.values()[C4Log.getBinaryFileLevel()];
    }

    @Override
    public void log(LogLevel level, LogDomain domain, String message) {
        if (level.compareTo(this._level) < 0 || !this._domainObjects.containsKey((Object)domain)) {
            return;
        }
        C4Log.log(this._domainObjects.get((Object)domain), level.getValue(), message);
    }
}

