/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Collation;
import com.couchbase.lite.PropertyExpression;
import com.couchbase.lite.internal.utils.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class Expression {
    Expression() {
    }

    @NonNull
    public static Expression value(Object value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression string(String value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression number(Number value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression intValue(int value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression longValue(long value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression floatValue(float value) {
        return new ValueExpression(Float.valueOf(value));
    }

    @NonNull
    public static Expression doubleValue(double value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression booleanValue(boolean value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression date(Date value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression map(Map<String, Object> value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression list(List<Object> value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static PropertyExpression all() {
        return new PropertyExpression("");
    }

    @NonNull
    public static PropertyExpression property(@NonNull String property) {
        if (property == null) {
            throw new IllegalArgumentException("property cannot be null.");
        }
        return new PropertyExpression(property);
    }

    @NonNull
    public static Expression parameter(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        return new ParameterExpression(name);
    }

    @NonNull
    public static Expression negated(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new CompoundExpression(Arrays.asList(expression), CompoundExpression.OpType.Not);
    }

    @NonNull
    public static Expression not(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return Expression.negated(expression);
    }

    @NonNull
    public Expression multiply(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Multiply);
    }

    @NonNull
    public Expression divide(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Divide);
    }

    @NonNull
    public Expression modulo(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Modulus);
    }

    @NonNull
    public Expression add(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Add);
    }

    @NonNull
    public Expression subtract(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Subtract);
    }

    @NonNull
    public Expression lessThan(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.LessThan);
    }

    @NonNull
    public Expression lessThanOrEqualTo(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.LessThanOrEqualTo);
    }

    @NonNull
    public Expression greaterThan(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression is null");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.GreaterThan);
    }

    @NonNull
    public Expression greaterThanOrEqualTo(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.GreaterThanOrEqualTo);
    }

    @NonNull
    public Expression equalTo(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.EqualTo);
    }

    @NonNull
    public Expression notEqualTo(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.NotEqualTo);
    }

    @NonNull
    public Expression and(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new CompoundExpression(Arrays.asList(this, expression), CompoundExpression.OpType.And);
    }

    @NonNull
    public Expression or(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new CompoundExpression(Arrays.asList(this, expression), CompoundExpression.OpType.Or);
    }

    @NonNull
    public Expression like(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Like);
    }

    @NonNull
    public Expression regex(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.RegexLike);
    }

    @NonNull
    public Expression is(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Is);
    }

    @NonNull
    public Expression isNot(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new BinaryExpression(this, expression, BinaryExpression.OpType.IsNot);
    }

    @NonNull
    public Expression between(@NonNull Expression expression1, @NonNull Expression expression2) {
        if (expression1 == null || expression2 == null) {
            throw new IllegalArgumentException("expression1 or expression2 cannot be null.");
        }
        AggregateExpression aggr = new AggregateExpression(Arrays.asList(expression1, expression2));
        return new BinaryExpression(this, aggr, BinaryExpression.OpType.Between);
    }

    @NonNull
    public Expression isNullOrMissing() {
        return new UnaryExpression(this, UnaryExpression.OpType.Null).or(new UnaryExpression(this, UnaryExpression.OpType.Missing));
    }

    @NonNull
    public Expression notNullOrMissing() {
        return Expression.negated(this.isNullOrMissing());
    }

    @NonNull
    public Expression collate(@NonNull Collation collation) {
        if (collation == null) {
            throw new IllegalArgumentException("collation cannot be null.");
        }
        return new CollationExpression(this, collation);
    }

    @NonNull
    public Expression in(Expression ... expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions cannot be null.");
        }
        AggregateExpression aggr = new AggregateExpression(Arrays.asList(expressions));
        return new BinaryExpression(this, aggr, BinaryExpression.OpType.In);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.ENGLISH, "%s[json=%s]", this.getClass().getSimpleName(), this.asJSON());
    }

    abstract Object asJSON();

    static final class FunctionExpression
    extends Expression {
        private String func = null;
        private List<Expression> params = null;

        FunctionExpression(String func, List<Expression> params) {
            this.func = func;
            this.params = params;
        }

        @Override
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add(this.func);
            for (Expression expr : this.params) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }

    static final class CollationExpression
    extends Expression {
        private Expression operand;
        private Collation collation;

        CollationExpression(Expression operand, Collation collation) {
            this.operand = operand;
            this.collation = collation;
        }

        @Override
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>(3);
            json.add("COLLATE");
            json.add(this.collation.asJSON());
            json.add(this.operand.asJSON());
            return json;
        }
    }

    static final class ParameterExpression
    extends Expression {
        private String name;

        ParameterExpression(String name) {
            this.name = name;
        }

        @Override
        Object asJSON() {
            ArrayList<String> json = new ArrayList<String>();
            json.add("$" + this.name);
            return json;
        }
    }

    static final class UnaryExpression
    extends Expression {
        private Expression operand;
        private OpType type;

        UnaryExpression(Expression operand, OpType type) {
            if (operand == null) {
                throw new AssertionError((Object)"operand cannot be null.");
            }
            this.operand = operand;
            this.type = type;
        }

        @Override
        Object asJSON() {
            Object opd = this.operand.asJSON();
            switch (this.type) {
                case Missing: {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add("MISSING");
                    return Arrays.asList("IS", opd, values);
                }
                case NotMissing: {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add("MISSING");
                    return Arrays.asList("IS NOT", opd, values);
                }
                case Null: {
                    return Arrays.asList("IS", opd, null);
                }
                case NotNull: {
                    return Arrays.asList("IS NOT", opd, null);
                }
            }
            return Arrays.asList(new Object[0]);
        }

        static enum OpType {
            Missing,
            NotMissing,
            NotNull,
            Null;

        }
    }

    static final class CompoundExpression
    extends Expression {
        private OpType type;
        private List<Expression> subexpressions;

        CompoundExpression(List<Expression> subexpressions, OpType type) {
            if (subexpressions == null) {
                throw new AssertionError((Object)"subexpressions cannot be null.");
            }
            this.type = type;
            this.subexpressions = subexpressions;
        }

        @Override
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            switch (this.type) {
                case And: {
                    json.add("AND");
                    break;
                }
                case Or: {
                    json.add("OR");
                    break;
                }
                case Not: {
                    json.add("NOT");
                }
            }
            for (Expression expr : this.subexpressions) {
                json.add(expr.asJSON());
            }
            return json;
        }

        static enum OpType {
            And,
            Or,
            Not;

        }
    }

    static final class BinaryExpression
    extends Expression {
        private Expression lhs;
        private Expression rhs;
        private OpType type;

        BinaryExpression(Expression lhs, Expression rhs, OpType type) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.type = type;
        }

        @Override
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            switch (this.type) {
                case Add: {
                    json.add("+");
                    break;
                }
                case Between: {
                    json.add("BETWEEN");
                    break;
                }
                case Divide: {
                    json.add("/");
                    break;
                }
                case EqualTo: {
                    json.add("=");
                    break;
                }
                case GreaterThan: {
                    json.add(">");
                    break;
                }
                case GreaterThanOrEqualTo: {
                    json.add(">=");
                    break;
                }
                case In: {
                    json.add("IN");
                    break;
                }
                case Is: {
                    json.add("IS");
                    break;
                }
                case IsNot: {
                    json.add("IS NOT");
                    break;
                }
                case LessThan: {
                    json.add("<");
                    break;
                }
                case LessThanOrEqualTo: {
                    json.add("<=");
                    break;
                }
                case Like: {
                    json.add("LIKE");
                    break;
                }
                case Modulus: {
                    json.add("%");
                    break;
                }
                case Multiply: {
                    json.add("*");
                    break;
                }
                case NotEqualTo: {
                    json.add("!=");
                    break;
                }
                case RegexLike: {
                    json.add("regexp_like()");
                    break;
                }
                case Subtract: {
                    json.add("-");
                }
            }
            json.add(this.lhs.asJSON());
            if (this.type == OpType.Between) {
                List<Expression> rangeExprs = ((AggregateExpression)this.rhs).getExpressions();
                json.add(rangeExprs.get(0).asJSON());
                json.add(rangeExprs.get(1).asJSON());
            } else {
                json.add(this.rhs.asJSON());
            }
            return json;
        }

        static enum OpType {
            Add,
            Between,
            Divide,
            EqualTo,
            GreaterThan,
            GreaterThanOrEqualTo,
            In,
            Is,
            IsNot,
            LessThan,
            LessThanOrEqualTo,
            Like,
            Modulus,
            Multiply,
            NotEqualTo,
            Subtract,
            RegexLike;

        }
    }

    static final class AggregateExpression
    extends Expression {
        private List<Expression> expressions;

        AggregateExpression(List<Expression> expressions) {
            this.expressions = expressions;
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        @Override
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("[]");
            for (Expression expr : this.expressions) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }

    static final class ValueExpression
    extends Expression {
        private Object value;

        ValueExpression(Object value) {
            if (!this.isSupportedType(value)) {
                throw new IllegalArgumentException("The given value's type is not supported.");
            }
            this.value = value;
        }

        @Override
        Object asJSON() {
            return this.asJSON(this.value);
        }

        private boolean isSupportedType(Object value) {
            return value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Date || value instanceof Map || value instanceof List || value instanceof Expression;
        }

        private Object asJSON(Object value) {
            if (value instanceof Date) {
                return DateUtils.toJson((Date)value);
            }
            if (value instanceof Map) {
                return this.mapAsJSON((Map)value);
            }
            if (value instanceof List) {
                return this.listAsJSON((List)value);
            }
            if (value instanceof Expression) {
                return ((Expression)value).asJSON();
            }
            if (!this.isSupportedType(value)) {
                throw new IllegalArgumentException("The value type is not supported: " + value);
            }
            return value;
        }

        private Object mapAsJSON(Map<String, Object> map) {
            HashMap<String, Object> json = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                json.put(entry.getKey(), this.asJSON(entry.getValue()));
            }
            return json;
        }

        private Object listAsJSON(List<Object> list) {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("[]");
            for (Object obj : list) {
                json.add(this.asJSON(obj));
            }
            return json;
        }
    }
}

