/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.litecore.C4Key;

public final class EncryptionKey {
    private static final String DEFAULT_PBKDF2_KEY_SALT = "Salty McNaCl";
    private static final int DEFAULT_PBKDF2_KEY_ROUNDS = 64000;
    private byte[] key = null;

    public EncryptionKey(@NonNull byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        if (key.length != 32) {
            throw new IllegalArgumentException("Key size is invalid. Key must be a 256-bit (32-byte) key.");
        }
        this.key = key;
    }

    public EncryptionKey(String password) {
        this(password != null ? C4Key.pbkdf2(password, DEFAULT_PBKDF2_KEY_SALT.getBytes(), 64000, 32) : null);
    }

    byte[] getKey() {
        return this.key;
    }

    static {
        NativeLibraryLoader.load();
    }
}

