/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.DefaultExecutor;
import com.couchbase.lite.DocumentReplication;
import com.couchbase.lite.DocumentReplicationListener;
import com.couchbase.lite.ListenerToken;
import java.util.concurrent.Executor;

final class DocumentReplicationListenerToken
implements ListenerToken {
    private Executor executor;
    private final DocumentReplicationListener listener;

    DocumentReplicationListenerToken(Executor executor, DocumentReplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("a listener parameter is null");
        }
        this.executor = executor;
        this.listener = listener;
    }

    void notify(final DocumentReplication update) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DocumentReplicationListenerToken.this.listener.replication(update);
            }
        });
    }

    Executor getExecutor() {
        return this.executor != null ? this.executor : DefaultExecutor.instance();
    }
}

