/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.ChangeNotifier;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.litecore.C4DocumentObserver;
import com.couchbase.litecore.C4DocumentObserverListener;

class DocumentChangeNotifier
extends ChangeNotifier<DocumentChange> {
    Database db;
    String docID;
    C4DocumentObserver obs;

    DocumentChangeNotifier(final Database db, String docID) {
        this.db = db;
        this.docID = docID;
        this.obs = db.c4db.createDocumentObserver(docID, new C4DocumentObserverListener(){

            @Override
            public void callback(C4DocumentObserver observer, String docID, long sequence, final Object context) {
                db.scheduleOnPostNotificationExecutor(new Runnable(){

                    @Override
                    public void run() {
                        ((DocumentChangeNotifier)context).postChange();
                    }
                }, 0L);
            }
        }, this);
    }

    void stop() {
        if (this.obs != null) {
            this.obs.free();
            this.obs = null;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    void postChange() {
        this.postChange(new DocumentChange(this.db, this.docID));
    }
}

