/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.litecore.C4Document;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLDict;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLSliceResult;
import com.couchbase.litecore.fleece.MRoot;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Document
implements DictionaryInterface,
Iterable<String> {
    private Database _database;
    private String _id;
    private C4Document _c4doc;
    private MRoot _root;
    private LiteCoreException encodingError;
    FLDict _data;
    Dictionary _dict;
    private final Object lock = new Object();

    Document(Database database, String id, C4Document c4doc) {
        this._database = database;
        this._id = id;
        this.setC4Document(c4doc);
    }

    Document(Database database, String id, boolean includeDeleted) throws CouchbaseLiteException {
        this(database, id, (C4Document)null);
        C4Document doc;
        try {
            if (this._database == null || this._database.getC4Database() == null) {
                throw new IllegalStateException();
            }
            doc = this._database.getC4Database().get(this.getId(), true);
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
        if (!includeDeleted && (doc.getFlags() & 1) != 0) {
            doc.retain();
            doc.release();
            throw new CouchbaseLiteException("CouchbaseLite", 7);
        }
        this.setC4Document(doc);
    }

    Document(Database database, String id, FLDict body) {
        this(database, id, (C4Document)null);
        this._data = body;
        this.updateDictionary();
    }

    @NonNull
    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSequence() {
        Object object = this.lock;
        synchronized (object) {
            return this._c4doc != null ? this._c4doc.getSelectedSequence() : 0L;
        }
    }

    @NonNull
    public MutableDocument toMutable() {
        return new MutableDocument(this, null);
    }

    @Override
    public int count() {
        return this._dict.count();
    }

    @Override
    @NonNull
    public List<String> getKeys() {
        return this._dict.getKeys();
    }

    @Override
    public Object getValue(@NonNull String key) {
        return this._dict.getValue(key);
    }

    @Override
    public String getString(@NonNull String key) {
        return this._dict.getString(key);
    }

    @Override
    public Number getNumber(@NonNull String key) {
        return this._dict.getNumber(key);
    }

    @Override
    public int getInt(@NonNull String key) {
        return this._dict.getInt(key);
    }

    @Override
    public long getLong(@NonNull String key) {
        return this._dict.getLong(key);
    }

    @Override
    public float getFloat(@NonNull String key) {
        return this._dict.getFloat(key);
    }

    @Override
    public double getDouble(@NonNull String key) {
        return this._dict.getDouble(key);
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        return this._dict.getBoolean(key);
    }

    @Override
    public Blob getBlob(@NonNull String key) {
        return this._dict.getBlob(key);
    }

    @Override
    public Date getDate(@NonNull String key) {
        return this._dict.getDate(key);
    }

    @Override
    public Array getArray(@NonNull String key) {
        return this._dict.getArray(key);
    }

    @Override
    public Dictionary getDictionary(@NonNull String key) {
        return this._dict.getDictionary(key);
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        return this._dict.toMap();
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this._dict.contains(key);
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document doc = (Document)o;
        if (this._database != null ? !this._database.equalsWithPath(doc._database) : doc._database != null) {
            return false;
        }
        if (!this._id.equals(doc._id)) {
            return false;
        }
        return this._dict.equals(doc._dict);
    }

    public int hashCode() {
        int result = this._database != null && this._database.getPath() != null ? this._database.getPath().hashCode() : 0;
        result = 31 * result + this._id.hashCode();
        result = 31 * result + this._dict.hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    void free() {
        this._root = null;
        if (this._c4doc != null) {
            this._c4doc.release();
            this._c4doc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setC4Document(C4Document c4doc) {
        Object object = this.lock;
        synchronized (object) {
            this.replaceC4Document(c4doc);
            this._data = null;
            if (c4doc != null && c4doc != null && !c4doc.deleted()) {
                this._data = c4doc.getSelectedBody2();
            }
            this.updateDictionary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceC4Document(C4Document c4doc) {
        Object object = this.lock;
        synchronized (object) {
            C4Document oldDoc = this._c4doc;
            this._c4doc = c4doc;
            if (oldDoc != this._c4doc) {
                if (this._c4doc != null) {
                    this._c4doc.retain();
                }
                if (oldDoc != null) {
                    oldDoc.release();
                }
            }
        }
    }

    boolean isMutable() {
        return false;
    }

    boolean isEmpty() {
        return this._dict.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDictionary() {
        if (this._data != null) {
            this._root = new MRoot(new DocContext(this._database, this._c4doc), this._data.toFLValue(), this.isMutable());
            Object object = this._database.getLock();
            synchronized (object) {
                this._dict = (Dictionary)this._root.asNative();
            }
        } else {
            this._root = null;
            this._dict = this.isMutable() ? new MutableDictionary() : new Dictionary();
        }
    }

    Database getDatabase() {
        return this._database;
    }

    void setDatabase(Database database) {
        this._database = database;
    }

    boolean exists() {
        return this._c4doc != null ? this._c4doc.exists() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long generation() {
        Object object = this.lock;
        synchronized (object) {
            return this.generationFromRevID(this.getRevID());
        }
    }

    long generationFromRevID(String revID) {
        long generation = 0L;
        long length = Math.min(revID == null ? 0 : revID.length(), 9);
        int i = 0;
        while ((long)i < length) {
            char c = revID.charAt(i);
            if (!Character.isDigit(c)) {
                if (c != '-') break;
                return generation;
            }
            generation = 10L * generation + (long)Character.getNumericValue(c);
            ++i;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C4Document getC4doc() {
        Object object = this.lock;
        synchronized (object) {
            return this._c4doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean selectConflictingRevision() throws LiteCoreException {
        Object object = this.lock;
        synchronized (object) {
            boolean foundConflict = false;
            if (this._c4doc != null) {
                while (!foundConflict) {
                    try {
                        this._c4doc.selectNextLeafRevision(true, true);
                    }
                    catch (LiteCoreException e) {
                        if (e.code == 0) break;
                        throw e;
                    }
                    foundConflict = this._c4doc.isSelectedRevFlags(32);
                }
            }
            if (foundConflict) {
                this.setC4Document(this._c4doc);
            }
            return foundConflict;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRevID() {
        Object object = this.lock;
        synchronized (object) {
            return this._c4doc != null ? this._c4doc.getSelectedRevID() : null;
        }
    }

    FLSliceResult encode() throws LiteCoreException {
        this.encodingError = null;
        FLEncoder encoder = this.getDatabase().getC4Database().getSharedFleeceEncoder();
        try {
            encoder.setExtraInfo(this);
            this._dict.encodeTo(encoder);
            if (this.encodingError != null) {
                encoder.reset();
                LiteCoreException ex = this.encodingError;
                this.encodingError = null;
                throw ex;
            }
            FLSliceResult fLSliceResult = encoder.finish2();
            return fLSliceResult;
        }
        finally {
            encoder.setExtraInfo(null);
        }
    }

    boolean isNewDocument() {
        return this.getRevID() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeleted() {
        Object object = this.lock;
        synchronized (object) {
            return this._c4doc != null && this._c4doc != null ? this._c4doc.deleted() : false;
        }
    }

    static {
        NativeLibraryLoader.load();
    }
}

