/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.lite.internal.utils.DateUtils;
import com.couchbase.litecore.fleece.Encoder;
import com.couchbase.litecore.fleece.FLEncodable;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MContext;
import com.couchbase.litecore.fleece.MDict;
import com.couchbase.litecore.fleece.MValue;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Dictionary
implements DictionaryInterface,
FLEncodable,
Iterable<String> {
    MDict _dict = new MDict();
    protected Object _sharedLock;

    Dictionary() {
        this.setupSharedLock();
    }

    Dictionary(MValue mv, MCollection parent) {
        this._dict.initInSlot(mv, parent);
        this.setupSharedLock();
    }

    Dictionary(MDict mDict, boolean isMutable) {
        this._dict.initAsCopyOf(mDict, isMutable);
        this.setupSharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        Object object = this._sharedLock;
        synchronized (object) {
            return (int)this._dict.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<String> getKeys() {
        Object object = this._sharedLock;
        synchronized (object) {
            return this._dict.getKeys();
        }
    }

    static MValue _get(MDict dict, String key) {
        return dict.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            return Dictionary._get(this._dict, key).asNative(this._dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Dictionary._get(this._dict, key).asNative(this._dict);
            return obj instanceof String ? (String)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getNumber(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Dictionary._get(this._dict, key).asNative(this._dict);
            return CBLConverter.asNumber(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asInteger(Dictionary._get(this._dict, key), this._dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asLong(Dictionary._get(this._dict, key), this._dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asFloat(Dictionary._get(this._dict, key), this._dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asDouble(Dictionary._get(this._dict, key), this._dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Dictionary._get(this._dict, key).asNative(this._dict);
            return CBLConverter.asBoolean(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Dictionary._get(this._dict, key).asNative(this._dict);
            return obj instanceof Blob ? (Blob)obj : null;
        }
    }

    @Override
    public Date getDate(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        return DateUtils.fromJson(this.getString(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Dictionary._get(this._dict, key).asNative(this._dict);
            return obj instanceof Array ? (Array)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary getDictionary(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Dictionary._get(this._dict, key).asNative(this._dict);
            return obj instanceof Dictionary ? (Dictionary)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> toMap() {
        Object object = this._sharedLock;
        synchronized (object) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : this._dict) {
                result.put(key, Fleece.toObject(Dictionary._get(this._dict, key).asNative(this._dict)));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object object = this._sharedLock;
        synchronized (object) {
            return !Dictionary._get(this._dict, key).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableDictionary toMutable() {
        Object object = this._sharedLock;
        synchronized (object) {
            return new MutableDictionary(this._dict, true);
        }
    }

    @Override
    @NonNull
    public void encodeTo(FLEncoder enc) {
        Encoder encoder = new Encoder(enc);
        this._dict.encodeTo(encoder);
        encoder.release();
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dictionary)) {
            return false;
        }
        Dictionary m = (Dictionary)o;
        if (m.count() != this.count()) {
            return false;
        }
        for (String key : this) {
            Object value = this.getValue(key);
            if (!(value == null ? m.getValue(key) != null || !m.contains(key) : !value.equals(m.getValue(key)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (String key : this) {
            h += this.hashCode(key, this.getValue(key));
        }
        return h;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected boolean isEmpty() {
        return this.count() == 0;
    }

    private void setupSharedLock() {
        MContext context = this._dict.getContext();
        this._sharedLock = context != null && context != MContext.NULL ? ((DocContext)context).getDatabase().getLock() : new Object();
    }

    private int hashCode(String key, Object value) {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
    }

    MCollection toMCollection() {
        return this._dict;
    }

    static {
        NativeLibraryLoader.load();
    }
}

