/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.content.Context;
import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractDatabaseConfiguration;
import com.couchbase.lite.EncryptionKey;

public final class DatabaseConfiguration
extends AbstractDatabaseConfiguration {
    private EncryptionKey encryptionKey = null;

    public DatabaseConfiguration(@NonNull Context context) {
        super(context);
        this.encryptionKey = null;
    }

    public DatabaseConfiguration(@NonNull DatabaseConfiguration config) {
        super(config);
        this.encryptionKey = config.encryptionKey;
    }

    @Override
    @NonNull
    public DatabaseConfiguration setDirectory(@NonNull String directory) {
        super.setDirectory(directory);
        return this;
    }

    @NonNull
    public DatabaseConfiguration setEncryptionKey(EncryptionKey encryptionKey) {
        if (this.isReadonly()) {
            throw new IllegalStateException("DatabaseConfiguration is readonly mode.");
        }
        this.encryptionKey = encryptionKey;
        return this;
    }

    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    DatabaseConfiguration readonlyCopy() {
        DatabaseConfiguration config = new DatabaseConfiguration(this);
        config.setReadonly(true);
        return config;
    }
}

