/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.EncryptionKey;
import com.couchbase.lite.Prediction;
import com.couchbase.litecore.C4Database;
import com.couchbase.litecore.LiteCoreException;

public final class Database
extends AbstractDatabase {
    @NonNull
    public static final Prediction prediction = new Prediction();

    public Database(@NonNull String name, @NonNull DatabaseConfiguration config) throws CouchbaseLiteException {
        super(name, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEncryptionKey(EncryptionKey encryptionKey) throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            int keyType = encryptionKey == null || encryptionKey.getKey() == null ? 0 : 1;
            try {
                this.c4db.rekey(keyType, encryptionKey != null ? encryptionKey.getKey() : null);
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    @Override
    int getEncryptionAlgorithm() {
        return this.config.getEncryptionKey() == null || this.config.getEncryptionKey().getKey() == null ? 0 : 1;
    }

    @Override
    byte[] getEncryptionKey() {
        return this.config.getEncryptionKey() == null ? null : this.config.getEncryptionKey().getKey();
    }

    Database(C4Database c4db) {
        super(c4db);
    }
}

