/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.util.Log;
import com.couchbase.lite.Database;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.litecore.C4Log;
import java.util.EnumSet;

public final class ConsoleLogger
implements Logger {
    private LogLevel _level = LogLevel.WARNING;
    private EnumSet<LogDomain> _domains = EnumSet.of(LogDomain.ALL);

    ConsoleLogger() {
    }

    @NonNull
    public EnumSet<LogDomain> getDomains() {
        return this._domains;
    }

    public void setDomains(@NonNull EnumSet<LogDomain> domains) {
        if (domains == null) {
            throw new IllegalArgumentException("domains cannot be null.");
        }
        this._domains = domains;
    }

    public void setLevel(@NonNull LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("level cannot be null.");
        }
        if (this._level == level) {
            return;
        }
        this._level = level;
        this.setCallbackLevel(level);
    }

    private void setCallbackLevel(@NonNull LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("level cannot be null.");
        }
        LogLevel callbackLevel = level;
        Logger custom = Database.log.getCustom();
        if (custom != null && custom.getLevel().compareTo(callbackLevel) < 0) {
            callbackLevel = custom.getLevel();
        }
        C4Log.setCallbackLevel(callbackLevel.getValue());
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        return this._level;
    }

    @Override
    public void log(LogLevel level, LogDomain domain, String message) {
        if (level.compareTo(this._level) < 0 || !this._domains.contains((Object)domain) && !this._domains.contains((Object)LogDomain.ALL)) {
            return;
        }
        switch (level) {
            case DEBUG: {
                Log.d((String)("CouchbaseLite/" + domain.toString()), (String)message);
                break;
            }
            case VERBOSE: {
                Log.v((String)("CouchbaseLite/" + domain.toString()), (String)message);
                break;
            }
            case INFO: {
                Log.i((String)("CouchbaseLite/" + domain.toString()), (String)message);
                break;
            }
            case WARNING: {
                Log.w((String)("CouchbaseLite/" + domain.toString()), (String)message);
                break;
            }
            case ERROR: {
                Log.e((String)("CouchbaseLite/" + domain.toString()), (String)message);
            }
        }
    }
}

