/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MValue;

final class CBLConverter {
    CBLConverter() {
    }

    static Number asNumber(Object value) {
        if (value != null && value instanceof Boolean) {
            return value == Boolean.TRUE ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        return ClassUtils.cast(value, Number.class);
    }

    static boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return true;
    }

    static int asInteger(MValue val, MCollection container) {
        if (val.getValue() != null) {
            return (int)val.getValue().asInt();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.intValue() : 0;
    }

    static long asLong(MValue val, MCollection container) {
        if (val.getValue() != null) {
            return val.getValue().asInt();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.longValue() : 0L;
    }

    static float asFloat(MValue val, MCollection container) {
        if (val.getValue() != null) {
            return val.getValue().asFloat();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.floatValue() : 0.0f;
    }

    static double asDouble(MValue val, MCollection container) {
        if (val.getValue() != null) {
            return val.getValue().asDouble();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.doubleValue() : 0.0;
    }
}

