/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Database;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.litecore.C4BlobKey;
import com.couchbase.litecore.C4BlobReadStream;
import com.couchbase.litecore.C4BlobStore;
import com.couchbase.litecore.C4BlobWriteStream;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLEncodable;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLSliceResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Blob
implements FLEncodable {
    static final LogDomain DOMAIN;
    static final String kMetaPropertyType = "@type";
    static final String kMetaPropertyDigest = "digest";
    static final String kMetaPropertyLength = "length";
    static final String kMetaPropertyContentType = "content_type";
    static final String kMetaPropertyData = "data";
    static final String kBlobType = "blob";
    static final int MAX_CACHED_CONTENT_LENGTH = 8192;
    private String contentType = null;
    private long length = 0L;
    private String digest = null;
    private byte[] content = null;
    private Map<String, Object> properties = null;
    private InputStream initialContentStream = null;
    private Database database = null;

    public Blob(@NonNull String contentType, @NonNull byte[] content) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType cannot be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null.");
        }
        this.contentType = contentType;
        this.content = content;
        this.length = content.length;
    }

    public Blob(@NonNull String contentType, @NonNull InputStream stream) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType cannot be null.");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null.");
        }
        this.contentType = contentType;
        this.initialContentStream = stream;
        this.length = 0L;
    }

    public Blob(@NonNull String contentType, @NonNull URL fileURL) throws IOException {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType cannot be null.");
        }
        if (fileURL == null) {
            throw new IllegalArgumentException("fileURL cannot be null.");
        }
        if (!fileURL.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "<%s> must be a file-based URL.", fileURL.toString()));
        }
        this.contentType = contentType;
        this.initialContentStream = fileURL.openStream();
        this.length = 0L;
    }

    Blob(Database database, Map<String, Object> properties) {
        this.database = database;
        this.properties = new HashMap<String, Object>(properties);
        this.properties.remove(kMetaPropertyType);
        if (properties.get(kMetaPropertyLength) != null && properties.get(kMetaPropertyLength) instanceof Number) {
            this.length = ClassUtils.cast(properties.get(kMetaPropertyLength), Number.class).longValue();
        }
        this.digest = ClassUtils.cast(properties.get(kMetaPropertyDigest), String.class);
        this.contentType = ClassUtils.cast(properties.get(kMetaPropertyContentType), String.class);
        Object data = properties.get(kMetaPropertyData);
        if (data != null && data instanceof byte[]) {
            this.content = (byte[])data;
        }
        if (this.digest == null && this.content == null) {
            Log.w(DOMAIN, "Blob read from database has neither digest nor data.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent() {
        if (this.content != null) {
            return this.content;
        }
        if (this.database != null) {
            byte[] contentResult = null;
            C4BlobStore blobStore = this.getBlobStore();
            try {
                C4BlobKey key = this.getBlobKey();
                if (key == null) {
                    throw new IllegalStateException("Invalid digest: " + this.digest);
                }
                try {
                    FLSliceResult res = blobStore.getContents(key);
                    try {
                        byte[] bytes = res.getBuf();
                        if (bytes != null) {
                            if (bytes.length <= 8192) {
                                this.content = bytes;
                            }
                            contentResult = bytes;
                        }
                    }
                    finally {
                        res.free();
                    }
                }
                catch (LiteCoreException e) {
                    Log.e(DOMAIN, "Failed to obtain content from BlobStore. digest=" + this.digest, e);
                    throw new IllegalStateException("Failed to obtain content from BlobStore. digest=" + this.digest, e);
                }
                finally {
                    key.free();
                }
                byte[] e = contentResult;
                return e;
            }
            finally {
                if (blobStore != null) {
                    blobStore.free();
                }
            }
        }
        byte[] contentResult = null;
        if (this.initialContentStream == null) {
            throw new IllegalStateException("initialContentStream variable is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                while ((bytesRead = this.initialContentStream.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                contentResult = out.toByteArray();
                this.length = contentResult.length;
                if (this.length <= 8192L) {
                    this.content = contentResult;
                }
            }
            catch (IOException e) {
                Log.w(DOMAIN, "I/O Error with the given stream.", e);
                throw new IllegalStateException(e);
            }
            finally {
                try {
                    this.initialContentStream.close();
                    this.initialContentStream = null;
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return contentResult;
    }

    public InputStream getContentStream() {
        if (this.database != null) {
            return new BlobInputStream(this.getBlobStore(), this.getBlobKey());
        }
        byte[] content = this.getContent();
        return content == null ? null : new ByteArrayInputStream(content);
    }

    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    public long length() {
        return this.length;
    }

    public String digest() {
        return this.digest;
    }

    @NonNull
    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(kMetaPropertyDigest, this.digest);
        props.put(kMetaPropertyLength, this.length);
        props.put(kMetaPropertyContentType, this.contentType);
        return props;
    }

    @NonNull
    public String toString() {
        return String.format(Locale.ENGLISH, "Blob[%s; %d KB]", this.contentType, (this.length() + 512L) / 1024L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Blob)) {
            return false;
        }
        Blob m = (Blob)o;
        if (this.digest != null && m.digest != null) {
            return this.digest.equals(m.digest);
        }
        return Arrays.equals(this.getContent(), m.getContent());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getContent());
    }

    Map<String, Object> jsonRepresentation() {
        HashMap<String, Object> json = new HashMap<String, Object>(this.getProperties());
        json.put(kMetaPropertyType, kBlobType);
        if (this.digest != null) {
            json.put(kMetaPropertyDigest, this.digest);
        } else {
            json.put(kMetaPropertyData, this.getContent());
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installInDatabase(Database db) {
        if (db == null) {
            throw new IllegalArgumentException("db cannot be null.");
        }
        if (this.database != null) {
            if (this.database != db) {
                throw new IllegalStateException("A document contains a blob that was saved to a different database; the save operation cannot complete.");
            }
            return;
        }
        C4BlobKey key = null;
        try {
            C4BlobStore store = db.getBlobStore();
            try {
                if (this.content != null) {
                    key = store.create(this.content);
                } else {
                    try (C4BlobWriteStream blobOut = store.openWriteStream();){
                        byte[] buffer = new byte[8192];
                        int bytesRead = 0;
                        this.length = 0L;
                        InputStream contentStream = this.getContentStream();
                        try {
                            if (contentStream == null) {
                                throw new IllegalStateException("No data available to write for install.  Please ensure that all blobs in the document have non-null content.");
                            }
                            while ((bytesRead = contentStream.read(buffer)) > 0) {
                                this.length += (long)bytesRead;
                                blobOut.write(Arrays.copyOfRange(buffer, 0, bytesRead));
                            }
                        }
                        finally {
                            try {
                                if (contentStream != null) {
                                    contentStream.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        key = blobOut.computeBlobKey();
                        blobOut.install();
                    }
                }
                this.digest = key.toString();
                this.database = db;
            }
            finally {
                if (store != null) {
                    store.free();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (key != null) {
                key.free();
            }
        }
    }

    @Override
    public void encodeTo(FLEncoder encoder) {
        Object info = encoder.getExtraInfo();
        if (info != null) {
            MutableDocument doc = (MutableDocument)info;
            Database db = doc.getDatabase();
            this.installInDatabase(db);
        }
        Map<String, Object> dict = this.jsonRepresentation();
        encoder.beginDict(dict.size());
        for (Map.Entry<String, Object> entry : dict.entrySet()) {
            encoder.writeKey(entry.getKey());
            encoder.writeValue(entry.getValue());
        }
        encoder.endDict();
    }

    private C4BlobStore getBlobStore() {
        if (this.database == null) {
            Log.w(DOMAIN, "database instance is null.");
            return null;
        }
        try {
            return this.database.getBlobStore();
        }
        catch (LiteCoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private C4BlobKey getBlobKey() {
        try {
            return new C4BlobKey(this.digest);
        }
        catch (LiteCoreException e) {
            Log.w(DOMAIN, "Invalid digest: " + this.digest, e);
            return null;
        }
    }

    static {
        NativeLibraryLoader.load();
        DOMAIN = LogDomain.DATABASE;
    }

    static final class BlobInputStream
    extends InputStream {
        C4BlobStore store = null;
        C4BlobKey key = null;
        boolean hasBytesAvailable = false;
        boolean closed = true;
        C4BlobReadStream readStream = null;

        BlobInputStream(C4BlobStore store, C4BlobKey key) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null.");
            }
            if (store == null) {
                key.free();
                throw new IllegalArgumentException("store cannot be null.");
            }
            this.store = store;
            this.key = key;
            try {
                this.readStream = store.openReadStream(key);
                this.hasBytesAvailable = true;
                this.closed = false;
            }
            catch (LiteCoreException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int read() throws IOException {
            try {
                byte[] bytes = this.readStream.read(1L);
                return bytes.length <= 0 ? -1 : bytes[0];
            }
            catch (LiteCoreException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b.length <= 0) {
                return 0;
            }
            try {
                byte[] bytes = this.readStream.read(len);
                if (bytes.length <= 0) {
                    return -1;
                }
                System.arraycopy(bytes, 0, b, off, bytes.length);
                return bytes.length;
            }
            catch (LiteCoreException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            try {
                this.readStream.seek(n);
                return n;
            }
            catch (LiteCoreException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.readStream != null) {
                this.readStream.close();
                this.readStream = null;
                this.closed = true;
                this.hasBytesAvailable = false;
            }
            if (this.key != null) {
                this.key.free();
                this.key = null;
            }
            if (this.store != null) {
                this.store.free();
                this.store = null;
            }
        }
    }
}

