/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Authenticator;
import java.util.HashMap;
import java.util.Map;

public final class BasicAuthenticator
extends Authenticator {
    private String username;
    private String password;

    public BasicAuthenticator(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null.");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null.");
        }
        this.username = username;
        this.password = password;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    @Override
    void authenticate(Map<String, Object> options) {
        HashMap<String, String> auth = new HashMap<String, String>();
        auth.put("type", "Basic");
        auth.put("username", this.username);
        auth.put("password", this.password);
        options.put("auth", auth);
    }
}

