/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.Arrays;

public final class ArrayFunction {
    private ArrayFunction() {
    }

    @NonNull
    public static Expression contains(@NonNull Expression expression, @NonNull Expression value) {
        if (expression == null || value == null) {
            throw new IllegalArgumentException("expression and value cannot be null.");
        }
        return new Expression.FunctionExpression("ARRAY_CONTAINS()", Arrays.asList(expression, value));
    }

    @NonNull
    public static Expression length(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("ARRAY_LENGTH()", Arrays.asList(expression));
    }
}

