/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.ArrayInterface;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.lite.internal.utils.DateUtils;
import com.couchbase.litecore.fleece.Encoder;
import com.couchbase.litecore.fleece.FLEncodable;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.MArray;
import com.couchbase.litecore.fleece.MCollection;
import com.couchbase.litecore.fleece.MContext;
import com.couchbase.litecore.fleece.MValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Array
implements ArrayInterface,
FLEncodable,
Iterable<Object> {
    MArray _array = new MArray();
    protected Object _sharedLock;

    Array() {
        this.setupSharedLock();
    }

    Array(MValue mv, MCollection parent) {
        this._array.initInSlot(mv, parent);
        this.setupSharedLock();
    }

    Array(MArray mArray, boolean isMutable) {
        this._array.initAsCopyOf(mArray, isMutable);
        this.setupSharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        Object object = this._sharedLock;
        synchronized (object) {
            return (int)this._array.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return Array._get(this._array, index).asNative(this._array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Array._get(this._array, index).asNative(this._array);
            return obj instanceof String ? (String)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getNumber(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asNumber(Array._get(this._array, index).asNative(this._array));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asInteger(Array._get(this._array, index), this._array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asLong(Array._get(this._array, index), this._array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asFloat(Array._get(this._array, index), this._array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return CBLConverter.asDouble(Array._get(this._array, index), this._array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            Object value = Array._get(this._array, index).asNative(this._array);
            return CBLConverter.asBoolean(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            return (Blob)Array._get(this._array, index).asNative(this._array);
        }
    }

    @Override
    public Date getDate(int index) {
        return DateUtils.fromJson(this.getString(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Array._get(this._array, index).asNative(this._array);
            return obj instanceof Array ? (Array)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary getDictionary(int index) {
        Object object = this._sharedLock;
        synchronized (object) {
            Object obj = Array._get(this._array, index).asNative(this._array);
            return obj instanceof Dictionary ? (Dictionary)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<Object> toList() {
        Object object = this._sharedLock;
        synchronized (object) {
            int count = (int)this._array.count();
            ArrayList<Object> result = new ArrayList<Object>(count);
            for (int index = 0; index < count; ++index) {
                result.add(Fleece.toObject(Array._get(this._array, index).asNative(this._array)));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableArray toMutable() {
        Object object = this._sharedLock;
        synchronized (object) {
            return new MutableArray(this._array, true);
        }
    }

    @Override
    @NonNull
    public void encodeTo(FLEncoder enc) {
        Encoder encoder = new Encoder(enc);
        this._array.encodeTo(encoder);
        encoder.release();
    }

    @Override
    @NonNull
    public Iterator<Object> iterator() {
        return new ArrayIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Array a = (Array)o;
        Iterator<Object> itr1 = this.iterator();
        Iterator<Object> itr2 = a.iterator();
        while (itr1.hasNext() && itr2.hasNext()) {
            Object o1 = itr1.next();
            Object o2 = itr2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !itr1.hasNext() && !itr2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        for (Object o : this) {
            h = 31 * h + (o == null ? 0 : o.hashCode());
        }
        return h;
    }

    static MValue _get(MArray array, int index) {
        MValue value = array.get(index);
        if (value.isEmpty()) {
            Array.throwRangeException(index);
        }
        return value;
    }

    static String throwRangeException(int index) {
        throw new IndexOutOfBoundsException("Array index " + index + " is out of range");
    }

    MCollection toMCollection() {
        return this._array;
    }

    private void setupSharedLock() {
        MContext context = this._array.getContext();
        this._sharedLock = context != null && context != MContext.NULL ? ((DocContext)context).getDatabase().getLock() : new Object();
    }

    static {
        NativeLibraryLoader.load();
    }

    private class ArrayIterator
    implements Iterator<Object> {
        private int index = 0;
        private int count = Array.this.count();

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public Object next() {
            return Array.this.getValue(this.index++);
        }
    }
}

