/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.NetworkReachabilityManager;
import com.couchbase.lite.internal.support.Log;

final class AndroidNetworkReachabilityManager
extends NetworkReachabilityManager {
    private static final LogDomain DOMAIN = LogDomain.REPLICATOR;
    private boolean listening = false;
    private Context context;
    private NetworkReceiver receiver;

    AndroidNetworkReachabilityManager(Context context) {
        this.context = context;
        this.receiver = new NetworkReceiver();
    }

    @Override
    void startListening() {
        if (!this.listening) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            Log.v(DOMAIN, "%s: startListening() registering %s with context %s", new Object[]{this, this.receiver, this.context});
            this.context.registerReceiver((BroadcastReceiver)this.receiver, filter);
            this.listening = true;
        }
    }

    @Override
    void stopListening() {
        if (this.listening) {
            try {
                Log.v(DOMAIN, "%s: stopListening() unregistering %s with context %s", new Object[]{this, this.receiver, this.context});
                this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
            }
            catch (Exception e) {
                Log.e(DOMAIN, "%s: stopListening() exception unregistering %s with context %s", e, new Object[]{this, this.receiver, this.context});
            }
            this.listening = false;
        }
    }

    private boolean isOnline(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private class NetworkReceiver
    extends BroadcastReceiver {
        private NetworkReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE") || !AndroidNetworkReachabilityManager.this.listening) {
                return;
            }
            boolean bOnline = AndroidNetworkReachabilityManager.this.isOnline(context);
            Log.v(DOMAIN, "NetworkReceiver.onReceive() Online -> " + bOnline);
            if (bOnline) {
                AndroidNetworkReachabilityManager.this.notifyListenersNetworkReachable();
            } else {
                AndroidNetworkReachabilityManager.this.notifyListenersNetworkUneachable();
            }
        }
    }
}

