/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AndroidNetworkReachabilityManager;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentFlag;
import com.couchbase.lite.DocumentReplication;
import com.couchbase.lite.DocumentReplicationListener;
import com.couchbase.lite.DocumentReplicationListenerToken;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.lite.NetworkReachabilityListener;
import com.couchbase.lite.NetworkReachabilityManager;
import com.couchbase.lite.ReplicatedDocument;
import com.couchbase.lite.Replicator;
import com.couchbase.lite.ReplicatorChange;
import com.couchbase.lite.ReplicatorChangeListener;
import com.couchbase.lite.ReplicatorChangeListenerToken;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.StringUtils;
import com.couchbase.litecore.C4Database;
import com.couchbase.litecore.C4DocumentEnded;
import com.couchbase.litecore.C4Error;
import com.couchbase.litecore.C4ReplicationFilter;
import com.couchbase.litecore.C4Replicator;
import com.couchbase.litecore.C4ReplicatorListener;
import com.couchbase.litecore.C4ReplicatorStatus;
import com.couchbase.litecore.C4Socket;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.FLDict;
import com.couchbase.litecore.fleece.FLEncoder;
import com.couchbase.litecore.fleece.FLValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class AbstractReplicator
extends NetworkReachabilityListener {
    protected static final LogDomain DOMAIN;
    static final String[] kC4ReplicatorActivityLevelNames;
    static final int kMaxOneShotRetryCount = 2;
    static final int kMaxRetryDelay = 600;
    private Object lock = new Object();
    protected ReplicatorConfiguration config;
    private Status status;
    private Set<ReplicatorChangeListenerToken> changeListenerTokens;
    private Set<DocumentReplicationListenerToken> docEndedListenerTokens;
    private C4Replicator c4repl;
    private C4ReplicatorStatus c4ReplStatus;
    private C4ReplicatorListener c4ReplListener;
    private C4ReplicationFilter c4ReplPushFilter;
    private C4ReplicationFilter c4ReplPullFilter;
    private ReplicatorProgressLevel progressLevel = ReplicatorProgressLevel.OVERALL;
    private int retryCount;
    private CouchbaseLiteException lastError;
    private String desc = null;
    private ScheduledExecutorService handler;
    private NetworkReachabilityManager reachabilityManager = null;
    private Map<String, Object> responseHeaders = null;
    private boolean resetCheckpoint = false;

    public AbstractReplicator(@NonNull ReplicatorConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.config = config.readonlyCopy();
        this.changeListenerTokens = Collections.synchronizedSet(new HashSet());
        this.docEndedListenerTokens = Collections.synchronizedSet(new HashSet());
        this.handler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable target) {
                return new Thread(target, "ReplicatorListenerThread");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            Log.i(DOMAIN, "Replicator is starting .....");
            if (this.c4repl != null) {
                Log.i(DOMAIN, "%s has already started", this);
                return;
            }
            Log.i(DOMAIN, "%s: Starting", this);
            this.retryCount = 0;
            this._start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            Log.i(DOMAIN, "%s: Replicator is stopping ...", this);
            if (this.c4repl != null) {
                this.c4repl.stop();
            } else {
                Log.i(DOMAIN, "%s: Replicator has been stopped or offlined ...", this);
            }
            if (this.c4ReplStatus.getActivityLevel() == 1) {
                Log.i(DOMAIN, "%s: Replicator has been offlined; make the replicator into the stopped state now.", this);
                C4ReplicatorStatus c4replStatus = new C4ReplicatorStatus();
                c4replStatus.setActivityLevel(0);
                this.c4StatusChanged(c4replStatus);
            }
            if (this.reachabilityManager != null) {
                this.reachabilityManager.removeNetworkReachabilityListener(this);
            }
        }
    }

    @NonNull
    public ReplicatorConfiguration getConfig() {
        return this.config.readonlyCopy();
    }

    @NonNull
    public Status getStatus() {
        return this.status.copy();
    }

    @NonNull
    public ListenerToken addChangeListener(@NonNull ReplicatorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.addChangeListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addChangeListener(Executor executor, @NonNull ReplicatorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            ReplicatorChangeListenerToken token = new ReplicatorChangeListenerToken(executor, listener);
            this.changeListenerTokens.add(token);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@NonNull ListenerToken token) {
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (token == null || !(token instanceof ReplicatorChangeListenerToken) && !(token instanceof DocumentReplicationListenerToken)) {
                throw new IllegalArgumentException();
            }
            this.changeListenerTokens.remove(token);
            this.docEndedListenerTokens.remove(token);
            if (this.docEndedListenerTokens.size() == 0) {
                this.setProgressLevel(ReplicatorProgressLevel.OVERALL);
            }
        }
    }

    @NonNull
    public ListenerToken addDocumentReplicationListener(@NonNull DocumentReplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.addDocumentReplicationListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addDocumentReplicationListener(Executor executor, @NonNull DocumentReplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.setProgressLevel(ReplicatorProgressLevel.PER_DOCUMENT);
            DocumentReplicationListenerToken token = new DocumentReplicationListenerToken(executor, listener);
            this.docEndedListenerTokens.add(token);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCheckpoint() {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4ReplStatus != null && this.c4ReplStatus.getActivityLevel() != 0) {
                throw new IllegalStateException("Replicator is not stopped. Resetting checkpoint is only allowed when the replicator is in the stopped state.");
            }
            this.resetCheckpoint = true;
        }
    }

    @NonNull
    public String toString() {
        if (this.desc == null) {
            this.desc = this.description();
        }
        return this.desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void networkReachable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4repl == null) {
                Log.i(DOMAIN, "%s: Server may now be reachable; retrying...", this);
                this.retryCount = 0;
                this.retry();
            }
        }
    }

    @Override
    void networkUnreachable() {
        Log.v(DOMAIN, "%s: Server may NOT be reachable now.", this);
    }

    protected void finalize() throws Throwable {
        this.clearRepl();
        if (this.reachabilityManager != null) {
            this.reachabilityManager.removeNetworkReachabilityListener(this);
            this.reachabilityManager = null;
        }
        super.finalize();
    }

    abstract void initSocketFactory(Object var1);

    abstract int framing();

    abstract String schema();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _start() {
        C4Database db = this.config.getDatabase().getC4Database();
        String schema = null;
        String host = null;
        int port = 0;
        String path = null;
        URI remoteURI = this.config.getTargetURI();
        String dbName = null;
        C4Database otherDB = null;
        if (remoteURI != null) {
            schema = remoteURI.getScheme();
            host = remoteURI.getHost();
            port = remoteURI.getPort() <= 0 ? 0 : remoteURI.getPort();
            path = StringUtils.stringByDeletingLastPathComponent(remoteURI.getPath());
            dbName = StringUtils.lastPathComponent(remoteURI.getPath());
        } else {
            otherDB = this.config.getTargetDatabase() != null ? this.config.getTargetDatabase().getC4Database() : null;
        }
        Map<String, Object> options = this.config.effectiveOptions();
        if (this.resetCheckpoint) {
            options.put("reset", true);
            this.resetCheckpoint = false;
        }
        options.put("progress", this.progressLevel.value);
        byte[] optionsFleece = null;
        if (options.size() > 0) {
            FLEncoder enc = new FLEncoder();
            enc.write(options);
            try {
                optionsFleece = enc.finish();
            }
            catch (LiteCoreException e) {
                Log.e(DOMAIN, "Failed to encode", e);
            }
            finally {
                enc.free();
            }
        }
        AbstractReplicator socketFactoryContext = this;
        this.initSocketFactory(socketFactoryContext);
        int framing = this.framing();
        if (this.schema() != null) {
            schema = this.schema();
        }
        C4Socket.socketFactoryContext.put(socketFactoryContext, (Replicator)this);
        boolean push = AbstractReplicator.isPush(this.config.getReplicatorType());
        boolean pull = AbstractReplicator.isPull(this.config.getReplicatorType());
        boolean continuous = this.config.isContinuous();
        if (this.config.getPushFilter() != null) {
            this.c4ReplPushFilter = new C4ReplicationFilter(){

                @Override
                public boolean validationFunction(String docID, int flags, long dict, boolean isPush, Object context) {
                    AbstractReplicator replicator = (AbstractReplicator)context;
                    return replicator.validationFunction(docID, AbstractReplicator.this.documentFlags(flags), dict, isPush);
                }
            };
        }
        if (this.config.getPullFilter() != null) {
            this.c4ReplPullFilter = new C4ReplicationFilter(){

                @Override
                public boolean validationFunction(String docID, int flags, long dict, boolean isPush, Object context) {
                    AbstractReplicator replicator = (AbstractReplicator)context;
                    return replicator.validationFunction(docID, AbstractReplicator.this.documentFlags(flags), dict, isPush);
                }
            };
        }
        this.c4ReplListener = new C4ReplicatorListener(){

            @Override
            public void statusChanged(C4Replicator repl, final C4ReplicatorStatus status, Object context) {
                Log.i(DOMAIN, "C4ReplicatorListener.statusChanged() status -> " + status);
                final AbstractReplicator replicator = (AbstractReplicator)context;
                if (repl == replicator.c4repl) {
                    AbstractReplicator.this.handler.execute(new Runnable(){

                        @Override
                        public void run() {
                            replicator.c4StatusChanged(status);
                        }
                    });
                }
            }

            @Override
            public void documentEnded(C4Replicator repl, final boolean pushing, final C4DocumentEnded[] documents, Object context) {
                final AbstractReplicator replicator = (AbstractReplicator)context;
                if (repl == replicator.c4repl) {
                    AbstractReplicator.this.handler.execute(new Runnable(){

                        @Override
                        public void run() {
                            replicator.documentEnded(pushing, documents);
                        }
                    });
                }
            }
        };
        C4ReplicatorStatus status = null;
        try {
            Object object = this.config.getDatabase().getLock();
            synchronized (object) {
                this.c4repl = db.createReplicator(schema, host, port, path, dbName, otherDB, AbstractReplicator.mkmode(push, continuous), AbstractReplicator.mkmode(pull, continuous), optionsFleece, this.c4ReplListener, this.c4ReplPushFilter, this.c4ReplPullFilter, this, socketFactoryContext, framing);
            }
            status = this.c4repl.getStatus();
            this.config.getDatabase().getActiveReplications().add((Replicator)this);
        }
        catch (LiteCoreException e) {
            status = new C4ReplicatorStatus(0, 0L, 0L, 0L, e.domain, e.code, 0);
        }
        this.updateStateProperties(status);
        this.c4ReplListener.statusChanged(this.c4repl, this.c4ReplStatus, this);
    }

    private void documentEnded(boolean pushing, C4DocumentEnded[] docEnds) {
        ArrayList<ReplicatedDocument> docs = new ArrayList<ReplicatedDocument>();
        for (C4DocumentEnded docEnd : docEnds) {
            String docID = docEnd.getDocID();
            C4Error error = docEnd.getC4Error();
            if (!pushing && docEnd.getErrorDomain() == 1 && docEnd.getErrorCode() == 8) {
                Log.i(DOMAIN, "%s: pulled conflicting version of '%s'", this, docID);
                try {
                    this.config.getDatabase().resolveConflictInDocument(docID);
                    error = new C4Error();
                }
                catch (CouchbaseLiteException ex) {
                    Log.e(DOMAIN, "Failed to resolveConflict: docID -> %s", ex, docID);
                }
            }
            ReplicatedDocument doc = new ReplicatedDocument(docID, docEnd.getFlags(), error, docEnd.errorIsTransient());
            docs.add(doc);
        }
        DocumentReplication update = new DocumentReplication((Replicator)this, pushing, docs);
        this.notifyDocumentEnded(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDocumentEnded(DocumentReplication update) {
        Set<DocumentReplicationListenerToken> set = this.docEndedListenerTokens;
        synchronized (set) {
            for (DocumentReplicationListenerToken token : this.docEndedListenerTokens) {
                token.notify(update);
            }
        }
        Log.i(DOMAIN, "C4ReplicatorListener.documentEnded() " + update.toString());
    }

    private EnumSet<DocumentFlag> documentFlags(int flags) {
        EnumSet<DocumentFlag> documentFlags = EnumSet.noneOf(DocumentFlag.class);
        if ((flags & 1) == 1) {
            documentFlags.add(DocumentFlag.DocumentFlagsDeleted);
        }
        if ((flags & 0x80) == 128) {
            documentFlags.add(DocumentFlag.DocumentFlagsAccessRemoved);
        }
        return documentFlags;
    }

    private boolean validationFunction(String docID, EnumSet<DocumentFlag> flags, long dict, boolean isPush) {
        Document document = new Document(this.config.getDatabase(), docID, new FLDict(dict));
        if (isPush) {
            return this.config.getPushFilter().filtered(document, flags);
        }
        return this.config.getPullFilter().filtered(document, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry() {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4repl != null || this.c4ReplStatus.getActivityLevel() != 1) {
                return;
            }
            Log.i(DOMAIN, "%s: Retrying...", this);
            this._start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c4StatusChanged(C4ReplicatorStatus c4Status) {
        Object object = this.lock;
        synchronized (object) {
            byte[] h;
            if (this.responseHeaders == null && this.c4repl != null && (h = this.c4repl.getResponseHeaders()) != null) {
                this.responseHeaders = FLValue.fromData(h).asDict();
            }
            Log.i(DOMAIN, "%s: status changed: " + c4Status, this);
            if (c4Status.getActivityLevel() == 0) {
                if (this.handleError(c4Status.getC4Error())) {
                    c4Status.setActivityLevel(1);
                }
            } else if (c4Status.getActivityLevel() > 2) {
                this.retryCount = 0;
                if (this.reachabilityManager != null) {
                    this.reachabilityManager.removeNetworkReachabilityListener(this);
                }
            }
            this.updateStateProperties(c4Status);
            Set<ReplicatorChangeListenerToken> set = this.changeListenerTokens;
            synchronized (set) {
                ReplicatorChange change = new ReplicatorChange((Replicator)this, this.getStatus());
                for (ReplicatorChangeListenerToken token : this.changeListenerTokens) {
                    token.notify(change);
                }
            }
            if (c4Status.getActivityLevel() == 0) {
                this.clearRepl();
                this.config.getDatabase().getActiveReplications().remove(this);
            }
        }
    }

    private boolean handleError(C4Error c4err) {
        boolean bTransient = C4Replicator.mayBeTransient(c4err) || c4err.getDomain() == 6 && c4err.getCode() == 4001;
        boolean bNetworkDependent = C4Replicator.mayBeNetworkDependent(c4err);
        if (!(bTransient || this.config.isContinuous() && bNetworkDependent)) {
            return false;
        }
        if (!this.config.isContinuous() && this.retryCount >= 2) {
            return false;
        }
        this.clearRepl();
        if (bTransient) {
            int delay = AbstractReplicator.retryDelay(++this.retryCount);
            Log.i(DOMAIN, "%s: Transient error (%s); will retry in %d sec...", this, c4err, delay);
            this.handler.schedule(new Runnable(){

                @Override
                public void run() {
                    AbstractReplicator.this.retry();
                }
            }, (long)delay, TimeUnit.SECONDS);
        } else {
            Log.i(DOMAIN, "%s: Network error (%s); will retry when network changes...", this, c4err);
        }
        this.startReachabilityObserver();
        return true;
    }

    private static int retryDelay(int retryCount) {
        int delay = 1 << Math.min(retryCount, 30);
        return Math.min(delay, 600);
    }

    private void updateStateProperties(C4ReplicatorStatus status) {
        CouchbaseLiteException error = null;
        if (status.getErrorCode() != 0) {
            error = CBLStatus.convertException(status.getErrorDomain(), status.getErrorCode(), status.getErrorInternalInfo());
        }
        if (error != this.lastError) {
            this.lastError = error;
        }
        this.c4ReplStatus = status.copy();
        ActivityLevel level = ActivityLevel.values()[status.getActivityLevel()];
        Progress progress = new Progress((int)status.getProgressUnitsCompleted(), (int)status.getProgressUnitsTotal());
        this.status = new Status(level, progress, error);
        Log.i(DOMAIN, "%s is %s, progress %d/%d, error: %s", this, kC4ReplicatorActivityLevelNames[status.getActivityLevel()], status.getProgressUnitsCompleted(), status.getProgressUnitsTotal(), error);
    }

    private void startReachabilityObserver() {
        URI remoteURI = this.config.getTargetURI();
        if (remoteURI == null) {
            return;
        }
        String hostname = remoteURI.getHost();
        if ("localhost".equals(hostname) || "127.0.0.1".equals(hostname)) {
            return;
        }
        if (this.reachabilityManager == null) {
            this.reachabilityManager = new AndroidNetworkReachabilityManager(this.config.getDatabase().getConfig().getContext());
        }
        this.reachabilityManager.addNetworkReachabilityListener(this);
    }

    private void clearRepl() {
        if (this.c4repl != null) {
            this.c4repl.free();
            this.c4repl = null;
        }
    }

    private String description() {
        return String.format(Locale.ENGLISH, "%s[%s%s%s %s %s]", Replicator.class.getSimpleName(), AbstractReplicator.isPull(this.config.getReplicatorType()) ? "<" : "", this.config.isContinuous() ? "*" : "-", AbstractReplicator.isPush(this.config.getReplicatorType()) ? ">" : "", this.config.getDatabase(), this.config.getTarget());
    }

    private void setProgressLevel(ReplicatorProgressLevel level) {
        this.progressLevel = level;
    }

    private static boolean isPush(ReplicatorConfiguration.ReplicatorType type) {
        return type == ReplicatorConfiguration.ReplicatorType.PUSH_AND_PULL || type == ReplicatorConfiguration.ReplicatorType.PUSH;
    }

    private static boolean isPull(ReplicatorConfiguration.ReplicatorType type) {
        return type == ReplicatorConfiguration.ReplicatorType.PUSH_AND_PULL || type == ReplicatorConfiguration.ReplicatorType.PULL;
    }

    private static int mkmode(boolean active, boolean continuous) {
        if (active && !continuous) {
            return 2;
        }
        if (active && continuous) {
            return 3;
        }
        return 0;
    }

    static {
        NativeLibraryLoader.load();
        DOMAIN = LogDomain.REPLICATOR;
        kC4ReplicatorActivityLevelNames = new String[]{"stopped", "offline", "connecting", "idle", "busy"};
    }

    public static final class Status {
        private final ActivityLevel activityLevel;
        private final Progress progress;
        private final CouchbaseLiteException error;

        private Status(ActivityLevel activityLevel, Progress progress, CouchbaseLiteException error) {
            this.activityLevel = activityLevel;
            this.progress = progress;
            this.error = error;
        }

        public Status(C4ReplicatorStatus c4Status) {
            this.activityLevel = ActivityLevel.values()[c4Status.getActivityLevel()];
            this.progress = new Progress((int)c4Status.getProgressUnitsCompleted(), (int)c4Status.getProgressUnitsTotal());
            this.error = c4Status.getErrorCode() != 0 ? CBLStatus.convertError(c4Status.getC4Error()) : null;
        }

        @NonNull
        public ActivityLevel getActivityLevel() {
            return this.activityLevel;
        }

        @NonNull
        public Progress getProgress() {
            return this.progress;
        }

        public CouchbaseLiteException getError() {
            return this.error;
        }

        @NonNull
        public String toString() {
            return "Status{activityLevel=" + (Object)((Object)this.activityLevel) + ", progress=" + this.progress + ", error=" + this.error + '}';
        }

        Status copy() {
            return new Status(this.activityLevel, this.progress.copy(), this.error);
        }
    }

    public static final class Progress {
        private long completed;
        private long total;

        private Progress(long completed, long total) {
            this.completed = completed;
            this.total = total;
        }

        public long getCompleted() {
            return this.completed;
        }

        public long getTotal() {
            return this.total;
        }

        @NonNull
        public String toString() {
            return "Progress{completed=" + this.completed + ", total=" + this.total + '}';
        }

        Progress copy() {
            return new Progress(this.completed, this.total);
        }
    }

    static enum ReplicatorProgressLevel {
        OVERALL(0),
        PER_DOCUMENT(1),
        PER_ATTACHMENT(2);

        private int value;

        int getValue() {
            return this.value;
        }

        private ReplicatorProgressLevel(int value) {
            this.value = value;
        }
    }

    public static enum ActivityLevel {
        STOPPED(0),
        OFFLINE(1),
        CONNECTING(2),
        IDLE(3),
        BUSY(4);

        private int value;

        private ActivityLevel(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

