/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DataSource;
import com.couchbase.lite.Database;
import com.couchbase.lite.Expression;
import com.couchbase.lite.GroupBy;
import com.couchbase.lite.Having;
import com.couchbase.lite.Joins;
import com.couchbase.lite.Limit;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiveQuery;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.lite.OrderBy;
import com.couchbase.lite.Parameters;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryChangeListener;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.Select;
import com.couchbase.lite.SelectResult;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.JsonUtils;
import com.couchbase.litecore.C4Query;
import com.couchbase.litecore.C4QueryEnumerator;
import com.couchbase.litecore.C4QueryOptions;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.fleece.AllocSlice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import org.json.JSONException;

abstract class AbstractQuery
implements Query {
    private static final LogDomain DOMAIN;
    private Database database;
    private C4Query c4query;
    private Select select;
    private DataSource from;
    private Joins joins;
    private Expression where;
    private GroupBy groupBy;
    private Having having;
    private OrderBy orderBy;
    private Limit limit;
    private Parameters parameters = null;
    private Map<String, Integer> columnNames = null;
    private LiveQuery liveQuery = null;
    private final Object lock = new Object();

    AbstractQuery() {
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameters(Parameters parameters) {
        LiveQuery liveQuery;
        Object object = this.lock;
        synchronized (object) {
            this.parameters = parameters != null ? parameters.readonlyCopy() : null;
            liveQuery = this.liveQuery;
        }
        if (liveQuery != null) {
            liveQuery.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ResultSet execute() throws CouchbaseLiteException {
        try {
            C4QueryEnumerator c4enum;
            C4QueryOptions options = new C4QueryOptions();
            if (this.parameters == null) {
                this.parameters = new Parameters();
            }
            AllocSlice params = this.parameters.encode();
            Object object = this.getDatabase().getLock();
            synchronized (object) {
                this.check();
                c4enum = this.c4query.run(options, params);
            }
            return new ResultSet(this, c4enum, this.columnNames);
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String explain() throws CouchbaseLiteException {
        Object object = this.getDatabase().getLock();
        synchronized (object) {
            this.check();
            return this.c4query.explain();
        }
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@NonNull QueryChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.addChangeListener(null, listener);
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(Executor executor, @NonNull QueryChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        return this.liveQuery().addChangeListener(executor, listener);
    }

    @Override
    public void removeChangeListener(@NonNull ListenerToken token) {
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        this.liveQuery().removeChangeListener(token);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.ENGLISH, "%s[json=%s]", this.getClass().getSimpleName(), this._asJSON());
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    Database getDatabase() {
        if (this.database == null) {
            this.database = (Database)this.from.getSource();
        }
        return this.database;
    }

    void setSelect(Select select) {
        this.select = select;
    }

    void setFrom(DataSource from) {
        this.from = from;
    }

    void setJoins(Joins joins) {
        this.joins = joins;
    }

    void setWhere(Expression where) {
        this.where = where;
    }

    void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    void setHaving(Having having) {
        this.having = having;
    }

    void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    void setLimit(Limit limit) {
        this.limit = limit;
    }

    void copy(AbstractQuery query) {
        this.select = query.select;
        this.from = query.from;
        this.joins = query.joins;
        this.where = query.where;
        this.groupBy = query.groupBy;
        this.having = query.having;
        this.orderBy = query.orderBy;
        this.limit = query.limit;
        this.parameters = query.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4query != null) {
                return;
            }
            this.database = (Database)this.from.getSource();
            String json = this.encodeAsJSON();
            Log.v(DOMAIN, "Query encoded as %s", json);
            if (json == null) {
                throw new CouchbaseLiteException("Failed to generate JSON query.");
            }
            if (this.columnNames == null) {
                this.columnNames = this.generateColumnNames();
            }
            try {
                this.c4query = this.database.getC4Database().createQuery(json);
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    private Map<String, Integer> generateColumnNames() throws CouchbaseLiteException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int index = 0;
        int provisionKeyIndex = 0;
        for (SelectResult selectResult : this.select.getSelectResults()) {
            String name = selectResult.getColumnName();
            if (name != null && name.equals("")) {
                name = this.from.getColumnName();
            }
            if (name == null) {
                name = String.format(Locale.ENGLISH, "$%d", ++provisionKeyIndex);
            }
            if (map.containsKey(name)) {
                String desc = String.format(Locale.ENGLISH, "Duplicate select result named %s", name);
                throw new CouchbaseLiteException(desc, "CouchbaseLite", 23);
            }
            map.put(name, index);
            ++index;
        }
        return map;
    }

    private String encodeAsJSON() {
        try {
            return JsonUtils.toJson(this._asJSON()).toString();
        }
        catch (JSONException e) {
            Log.w(DOMAIN, "Error when encoding the query as a json string", e);
            return null;
        }
    }

    private Map<String, Object> _asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (this.select != null && this.select.isDistinct()) {
            json.put("DISTINCT", true);
        }
        if (this.select != null && this.select.hasSelectResults()) {
            json.put("WHAT", this.select.asJSON());
        }
        ArrayList<Map<String, Object>> f = new ArrayList<Map<String, Object>>();
        Map<String, Object> as = this.from.asJSON();
        if (as.size() > 0) {
            f.add(as);
        }
        if (this.joins != null) {
            f.addAll((List)this.joins.asJSON());
        }
        if (f.size() > 0) {
            json.put("FROM", f);
        }
        if (this.where != null) {
            json.put("WHERE", this.where.asJSON());
        }
        if (this.groupBy != null) {
            json.put("GROUP_BY", this.groupBy.asJSON());
        }
        if (this.having != null) {
            json.put("HAVING", this.having.asJSON());
        }
        if (this.orderBy != null) {
            json.put("ORDER_BY", this.orderBy.asJSON());
        }
        if (this.limit != null) {
            List list = (List)this.limit.asJSON();
            json.put("LIMIT", list.get(0));
            if (list.size() > 1) {
                json.put("OFFSET", list.get(1));
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LiveQuery liveQuery() {
        Object object = this.lock;
        synchronized (object) {
            if (this.liveQuery == null) {
                this.liveQuery = new LiveQuery(this);
            }
            return this.liveQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free() {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4query != null && this.getDatabase() != null) {
                Object object2 = this.getDatabase().getLock();
                synchronized (object2) {
                    this.c4query.free();
                }
                this.c4query = null;
            }
        }
    }

    static {
        NativeLibraryLoader.load();
        DOMAIN = LogDomain.QUERY;
    }
}

