/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentracing;

import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.tracing.opentracing.OpenTracingRequestSpan;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;

public class OpenTracingInternalSpan
implements InternalSpan {
    private final Tracer tracer;
    private final Span span;
    private volatile RequestContext ctx;
    private volatile Span dispatchSpan;
    private volatile Span encodingSpan;

    OpenTracingInternalSpan(Tracer tracer, Span parent, String operationName) {
        this.tracer = tracer;
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(operationName);
        if (parent != null) {
            spanBuilder.asChildOf(parent);
        }
        this.span = spanBuilder.start();
        tracer.activateSpan(this.span).close();
    }

    public void finish() {
        try (Scope scope = this.tracer.activateSpan(this.span);){
            this.span.setTag((Tag)Tags.PEER_SERVICE, (Object)this.mapServiceType(this.ctx.request().serviceType()));
            String operationId = this.ctx.request().operationId();
            if (operationId != null) {
                this.span.setTag("couchbase.operation_id", operationId);
            }
            if (this.ctx.request() instanceof BaseKeyValueRequest) {
                this.span.setTag("couchbase.document_id", new String(((BaseKeyValueRequest)this.ctx.request()).key(), CharsetUtil.UTF_8));
            }
            if (this.ctx.clientContext() != null) {
                this.ctx.clientContext().forEach((key, value) -> this.span.setTag("couchbase.client_context." + key, value.toString()));
            }
            this.span.finish();
        }
    }

    private String mapServiceType(ServiceType serviceType) {
        switch (serviceType) {
            case KV: {
                return "kv";
            }
            case QUERY: {
                return "query";
            }
            case ANALYTICS: {
                return "analytics";
            }
            case VIEWS: {
                return "view";
            }
            case SEARCH: {
                return "search";
            }
        }
        return null;
    }

    public void requestContext(RequestContext ctx) {
        this.ctx = ctx;
    }

    public RequestContext requestContext() {
        return this.ctx;
    }

    public void startDispatch() {
        this.dispatchSpan = this.tracer.buildSpan("dispatch_to_server").asChildOf(this.span).start();
        this.tracer.activateSpan(this.dispatchSpan).close();
    }

    public void stopDispatch() {
        try (Scope scope = this.tracer.activateSpan(this.dispatchSpan);){
            long serverLatency = this.ctx.serverLatency();
            if (serverLatency > 0L) {
                this.dispatchSpan.setTag("peer.latency", (Number)serverLatency);
            }
            this.dispatchSpan.finish();
        }
    }

    public void startPayloadEncoding() {
        this.encodingSpan = this.tracer.buildSpan("request_encoding").asChildOf(this.span).start();
        this.tracer.activateSpan(this.encodingSpan).close();
    }

    public void stopPayloadEncoding() {
        try (Scope scope = this.tracer.activateSpan(this.encodingSpan);){
            this.encodingSpan.finish();
        }
    }

    public RequestSpan toRequestSpan() {
        return OpenTracingRequestSpan.wrap(this.tracer, this.span);
    }
}

