/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6;

import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

enum GrpcRpcAttributesGetter implements RpcAttributesGetter<GrpcRequest>
{
    INSTANCE;


    public String getSystem(GrpcRequest request) {
        return "grpc";
    }

    @Nullable
    public String getService(GrpcRequest request) {
        String fullMethodName = request.getMethod().getFullMethodName();
        int slashIndex = fullMethodName.lastIndexOf(47);
        if (slashIndex == -1) {
            return null;
        }
        return fullMethodName.substring(0, slashIndex);
    }

    @Nullable
    public String getMethod(GrpcRequest request) {
        String fullMethodName = request.getMethod().getFullMethodName();
        int slashIndex = fullMethodName.lastIndexOf(47);
        if (slashIndex == -1) {
            return null;
        }
        return fullMethodName.substring(slashIndex + 1);
    }

    List<String> metadataValue(GrpcRequest request, String key) {
        if (request.getMetadata() == null) {
            return Collections.emptyList();
        }
        if (key == null || key.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable values = request.getMetadata().getAll(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        if (values == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(values.spliterator(), false).collect(Collectors.toList());
    }
}

