/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.deps.io.grpc.ClientInterceptor;
import com.couchbase.client.core.deps.io.grpc.ManagedChannelBuilder;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.TracerException;
import com.couchbase.client.core.protostellar.GrpcAwareRequestTracer;
import com.couchbase.client.tracing.opentelemetry.OpenTelemetryRequestSpan;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.net.URL;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class OpenTelemetryRequestTracer
implements RequestTracer,
GrpcAwareRequestTracer {
    public static final String INSTRUMENTATION_NAME = "com.couchbase.client.jvm";
    private static final Map<String, Attributes> MANIFEST_INFOS = new ConcurrentHashMap<String, Attributes>();
    private final Tracer tracer;
    @Nullable
    private final OpenTelemetry openTelemetry;

    public static OpenTelemetryRequestTracer wrap(OpenTelemetry openTelemetry) {
        return new OpenTelemetryRequestTracer(openTelemetry.getTracerProvider(), openTelemetry);
    }

    public static OpenTelemetryRequestTracer wrap(TracerProvider tracerProvider) {
        return new OpenTelemetryRequestTracer(tracerProvider, null);
    }

    private OpenTelemetryRequestTracer(TracerProvider tracerProvider, @Nullable OpenTelemetry openTelemetry) {
        String version = null;
        try {
            version = MANIFEST_INFOS.get("couchbase-java-tracing-opentelemetry").getValue("Impl-Version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tracer = version != null ? tracerProvider.get(INSTRUMENTATION_NAME, version) : tracerProvider.get(INSTRUMENTATION_NAME);
        this.openTelemetry = openTelemetry;
    }

    private Span castSpan(RequestSpan requestSpan) {
        if (requestSpan == null) {
            return null;
        }
        if (requestSpan instanceof OpenTelemetryRequestSpan) {
            return ((OpenTelemetryRequestSpan)requestSpan).span();
        }
        throw new IllegalArgumentException("RequestSpan must be of type OpenTelemetryRequestSpan");
    }

    public Tracer tracer() {
        return this.tracer;
    }

    public RequestSpan requestSpan(String operationName, RequestSpan parent) {
        try {
            SpanBuilder spanBuilder = this.tracer.spanBuilder(operationName).setSpanKind(SpanKind.CLIENT);
            Context parentContext = Context.current();
            if (parent != null) {
                parentContext = parentContext.with((ImplicitContextKeyed)this.castSpan(parent));
            }
            Span span = spanBuilder.setParent(parentContext).startSpan();
            return OpenTelemetryRequestSpan.wrap(span);
        }
        catch (Exception ex) {
            throw new TracerException("Failed to create OpenTelemetryRequestSpan", (Throwable)ex);
        }
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }

    public void registerGrpc(ManagedChannelBuilder<?> builder) {
        if (this.openTelemetry != null) {
            GrpcTelemetry grpcTelemetry = GrpcTelemetry.create((OpenTelemetry)this.openTelemetry);
            ClientInterceptor interceptor = grpcTelemetry.newClientInterceptor();
            builder.intercept(new ClientInterceptor[]{interceptor});
        }
    }

    public AutoCloseable activateSpan(RequestSpan span) {
        return this.castSpan(span).makeCurrent();
    }

    static {
        try {
            Enumeration<URL> resources = CoreEnvironment.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest;
                URL manifestUrl = resources.nextElement();
                if (manifestUrl == null || (manifest = new Manifest(manifestUrl.openStream())).getEntries() == null) continue;
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    if (!entry.getKey().startsWith("couchbase-")) continue;
                    MANIFEST_INFOS.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

