/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.tracing.opentelemetry.OpenTelemetryRequestSpan;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.net.URL;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import reactor.core.publisher.Mono;

public class OpenTelemetryRequestTracer
implements RequestTracer {
    public static final String INSTRUMENTATION_NAME = "com.couchbase.client.jvm";
    private static final Map<String, Attributes> MANIFEST_INFOS = new ConcurrentHashMap<String, Attributes>();
    private final Tracer tracer;

    public static OpenTelemetryRequestTracer wrap(OpenTelemetry openTelemetry) {
        return OpenTelemetryRequestTracer.wrap(openTelemetry.getTracerProvider());
    }

    public static OpenTelemetryRequestTracer wrap(TracerProvider tracerProvider) {
        return new OpenTelemetryRequestTracer(tracerProvider);
    }

    private OpenTelemetryRequestTracer(TracerProvider tracerProvider) {
        String version = null;
        try {
            version = MANIFEST_INFOS.get("couchbase-java-tracing-opentelemetry").getValue("Impl-Version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tracer = version != null ? tracerProvider.get(INSTRUMENTATION_NAME, version) : tracerProvider.get(INSTRUMENTATION_NAME);
    }

    private Span castSpan(RequestSpan requestSpan) {
        if (requestSpan == null) {
            return null;
        }
        if (requestSpan instanceof OpenTelemetryRequestSpan) {
            return ((OpenTelemetryRequestSpan)requestSpan).span();
        }
        throw new IllegalArgumentException("RequestSpan must be of type OpenTelemetryRequestSpan");
    }

    public Tracer tracer() {
        return this.tracer;
    }

    public RequestSpan requestSpan(String operationName, RequestSpan parent) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operationName);
        Context parentContext = Context.current();
        if (parent != null) {
            parentContext = parentContext.with((ImplicitContextKeyed)this.castSpan(parent));
        }
        Span span = spanBuilder.setParent(parentContext).startSpan();
        return OpenTelemetryRequestSpan.wrap(span);
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }

    static {
        try {
            Enumeration<URL> resources = CoreEnvironment.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest;
                URL manifestUrl = resources.nextElement();
                if (manifestUrl == null || (manifest = new Manifest(manifestUrl.openStream())).getEntries() == null) continue;
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    if (!entry.getKey().startsWith("couchbase-")) continue;
                    MANIFEST_INFOS.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

