/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.util.Validators;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.time.Instant;

public class OpenTelemetryRequestSpan
implements RequestSpan {
    private final Span span;
    private final Tracer tracer;
    private volatile RequestContext requestContext;

    private OpenTelemetryRequestSpan(Tracer tracer, Span span) {
        Validators.notNull((Object)tracer, (String)"Tracer");
        Validators.notNull((Object)span, (String)"Span");
        this.tracer = tracer;
        this.span = span;
    }

    public static OpenTelemetryRequestSpan wrap(Tracer tracer, Span span) {
        return new OpenTelemetryRequestSpan(tracer, span);
    }

    Span span() {
        return this.span;
    }

    public void setAttribute(String key, String value) {
        this.span.setAttribute(key, value);
    }

    public void addEvent(String name, Instant timestamp) {
        this.span.addEvent(name, timestamp);
    }

    public void end() {
        try (Scope scope = this.span.makeCurrent();){
            this.span.end();
        }
    }

    public void requestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }
}

