/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.util.Validators;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;

public class OpenTelemetryRequestSpan
implements RequestSpan {
    private final Span span;
    private final Tracer tracer;

    private OpenTelemetryRequestSpan(Tracer tracer, Span span) {
        Validators.notNull((Object)tracer, (String)"Tracer");
        Validators.notNull((Object)span, (String)"Span");
        this.tracer = tracer;
        this.span = span;
    }

    public static OpenTelemetryRequestSpan wrap(Tracer tracer, Span span) {
        return new OpenTelemetryRequestSpan(tracer, span);
    }

    Span span() {
        return this.span;
    }

    public void finish() {
        try (Scope scope = this.tracer.withSpan(this.span);){
            this.span.end();
        }
    }
}

