/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.tracing.opentelemetry.OpenTelemetryInternalSpan;
import com.couchbase.client.tracing.opentelemetry.OpenTelemetryRequestSpan;
import io.grpc.Context;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class OpenTelemetryRequestTracer
implements RequestTracer {
    private final Tracer tracer;

    public static OpenTelemetryRequestTracer wrap(Tracer tracer) {
        return new OpenTelemetryRequestTracer(tracer);
    }

    private OpenTelemetryRequestTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public OpenTelemetryInternalSpan internalSpan(String operationName, RequestSpan requestSpan) {
        Validators.notNullOrEmpty((String)operationName, (String)"OperationName");
        return new OpenTelemetryInternalSpan(this.tracer, this.castSpan(requestSpan), operationName);
    }

    private Span castSpan(RequestSpan requestSpan) {
        if (requestSpan == null) {
            return null;
        }
        if (requestSpan instanceof OpenTelemetryRequestSpan) {
            return ((OpenTelemetryRequestSpan)requestSpan).span();
        }
        throw new IllegalArgumentException("RequestSpan must be of type OpenTelemetryRequestSpan");
    }

    public RequestSpan requestSpan(String operationName, RequestSpan parent) {
        Span.Builder spanBuilder = this.tracer.spanBuilder(operationName);
        if (parent != null) {
            spanBuilder.setParent(TracingContextUtils.withSpan((Span)this.castSpan(parent), (Context)Context.current()));
        } else {
            spanBuilder.setNoParent();
        }
        Span span = spanBuilder.startSpan();
        this.tracer.withSpan(span).close();
        return OpenTelemetryRequestSpan.wrap(this.tracer, span);
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }
}

