/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.observation;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.error.TracerException;
import com.couchbase.client.tracing.observation.CouchbaseSenderContext;
import com.couchbase.client.tracing.observation.ObservationRequestSpan;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.ObservationView;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class ObservationRequestTracer
implements RequestTracer {
    private final ObservationRegistry observationRegistry;

    public static ObservationRequestTracer wrap(ObservationRegistry observationRegistry) {
        return new ObservationRequestTracer(observationRegistry);
    }

    private ObservationRequestTracer(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    private Observation castObservation(RequestSpan requestSpan) {
        if (requestSpan == null) {
            return null;
        }
        if (requestSpan instanceof ObservationRequestSpan) {
            return ((ObservationRequestSpan)requestSpan).observation();
        }
        throw new IllegalArgumentException("RequestSpan must be of type ObservationRequestSpan");
    }

    public ObservationRegistry observationRegistry() {
        return this.observationRegistry;
    }

    public RequestSpan requestSpan(String operationName, RequestSpan parent) {
        try {
            CouchbaseSenderContext senderContext = new CouchbaseSenderContext(operationName);
            if (parent != null) {
                senderContext.setParentObservation((ObservationView)this.castObservation(parent));
            }
            Observation observation = Observation.createNotStarted((String)"db.couchbase.operations", () -> senderContext, (ObservationRegistry)this.observationRegistry).contextualName(operationName);
            return ObservationRequestSpan.wrap(observation.start());
        }
        catch (Exception ex) {
            throw new TracerException("Failed to create ObservationRequestSpan", (Throwable)ex);
        }
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }
}

