/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.error.CommonExceptions;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.ReplicaGetRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class GetFromReplicaHandler {
    private final HandlerParams hp;

    public GetFromReplicaHandler(HandlerParams hp) {
        this.hp = hp;
    }

    public <T> Try<Seq<GetRequest>> requestAll(String id, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable)x$12 -> {
            String string = x$12;
            return Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                return Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable)x$12 -> {
                    Object object = x$12;
                    return Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable)x$1 -> {
                        Object object = x$1;
                        return null;
                    });
                });
            });
        });
        if (validations.isFailure()) {
            return validations;
        }
        BucketConfig bucketConfig = this.hp.core().clusterConfig().bucketConfig(this.hp.bucketName());
        if (bucketConfig instanceof CouchbaseBucketConfig) {
            CouchbaseBucketConfig config = (CouchbaseBucketConfig)bucketConfig;
            int numReplicas = config.numberOfReplicas();
            IndexedSeq replicaRequests = package$.MODULE$.Range().apply(0, numReplicas).map((Function1 & Serializable)replicaIndex -> this.$anonfun$2(id, timeout, retryStrategy, parentSpan, BoxesRunTime.unboxToInt((Object)replicaIndex)));
            GetRequest activeRequest = new GetRequest(id, timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, this.hp.tracer().requestSpan("get", (RequestSpan)parentSpan.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            Seq requests = (Seq)replicaRequests.$plus$colon((Object)activeRequest);
            return Success$.MODULE$.apply((Object)requests);
        }
        return Failure$.MODULE$.apply((Throwable)CommonExceptions.getFromReplicaNotCouchbaseBucket());
    }

    public Option<GetReplicaResult> response(KeyValueRequest<GetResponse> request, String id, GetResponse response, boolean isReplica, Transcoder transcoder) {
        ResponseStatus responseStatus = response.status();
        ResponseStatus responseStatus2 = ResponseStatus.SUCCESS;
        ResponseStatus responseStatus3 = responseStatus;
        if (!(responseStatus2 != null ? !responseStatus2.equals(responseStatus3) : responseStatus3 != null)) {
            return Some$.MODULE$.apply((Object)new GetReplicaResult(id, (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)response.content()), response.flags(), response.cas(), (Option<Instant>)Option$.MODULE$.empty(), isReplica, transcoder));
        }
        ResponseStatus responseStatus4 = ResponseStatus.NOT_FOUND;
        ResponseStatus responseStatus5 = responseStatus;
        if (!(responseStatus4 != null ? !responseStatus4.equals(responseStatus5) : responseStatus5 != null)) {
            return None$.MODULE$;
        }
        throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
    }

    private final /* synthetic */ ReplicaGetRequest $anonfun$2(String id$1, Duration timeout$2, RetryStrategy retryStrategy$3, Option parentSpan$4, int replicaIndex) {
        return new ReplicaGetRequest(id$1, timeout$2, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy$3, Predef$.MODULE$.int2Integer(replicaIndex + 1).shortValue(), this.hp.tracer().requestSpan("get_replica", (RequestSpan)parentSpan$4.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }
}

