/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.EncodedValue$;
import com.couchbase.client.scala.codec.RawJsonTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import java.nio.charset.StandardCharsets;
import scala.reflect.ClassTag;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class RawJsonTranscoder
implements TranscoderWithoutSerializer {
    public static RawJsonTranscoder Instance() {
        return RawJsonTranscoder$.MODULE$.Instance();
    }

    @Override
    public <T> Try<EncodedValue> encode(T value) {
        T t = value;
        if (t instanceof byte[]) {
            byte[] x = (byte[])t;
            return Success$.MODULE$.apply((Object)EncodedValue$.MODULE$.apply(x, CodecFlags.JSON_COMPAT_FLAGS));
        }
        if (t instanceof String) {
            String x = (String)t;
            return Success$.MODULE$.apply((Object)EncodedValue$.MODULE$.apply(x.getBytes(StandardCharsets.UTF_8), CodecFlags.JSON_COMPAT_FLAGS));
        }
        return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException("Only Array[Byte] and String types are supported for the RawJsonTranscoder!"));
    }

    @Override
    public <T> Try<T> decode(byte[] value, int flags, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(byte[].class)) {
            return Success$.MODULE$.apply((Object)value);
        }
        if (tag.runtimeClass().isAssignableFrom(String.class)) {
            return Success$.MODULE$.apply((Object)new String(value, StandardCharsets.UTF_8));
        }
        return Failure$.MODULE$.apply((Throwable)new DecodingFailureException("RawJsonTranscoder can only decode into Array[Byte] or String!"));
    }
}

