/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.EncodedValue$;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.LegacyTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.util.Success$;
import scala.util.Try;

public class LegacyTranscoder
implements TranscoderWithSerializer {
    public static LegacyTranscoder Instance() {
        return LegacyTranscoder$.MODULE$.Instance();
    }

    public <T> Try<EncodedValue> encode(T value, JsonSerializer<T> serializer) {
        T t = value;
        if (t instanceof byte[]) {
            byte[] x = (byte[])t;
            return Success$.MODULE$.apply((Object)EncodedValue$.MODULE$.apply(x, CodecFlags.BINARY_COMPAT_FLAGS));
        }
        if (t instanceof String) {
            String x = (String)t;
            return Success$.MODULE$.apply((Object)EncodedValue$.MODULE$.apply(x.getBytes(StandardCharsets.UTF_8), CodecFlags.STRING_COMPAT_FLAGS));
        }
        return serializer.serialize(value).map((Function1 & Serializable)bytes -> EncodedValue$.MODULE$.apply((byte[])bytes, CodecFlags.JSON_COMPAT_FLAGS));
    }

    public <T> Try<T> decode(byte[] input, int flags, JsonDeserializer<T> serializer, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(byte[].class)) {
            return Success$.MODULE$.apply((Object)input);
        }
        if (tag.runtimeClass().isAssignableFrom(String.class)) {
            return Success$.MODULE$.apply((Object)new String(input, StandardCharsets.UTF_8));
        }
        return serializer.deserialize(input);
    }
}

