/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.api.kv.CoreExistsResult;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.BinaryCollection;
import com.couchbase.client.scala.CollectionBase;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.kv.ExistsOptions;
import com.couchbase.client.scala.kv.ExistsOptions$;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.GetAndLockOptions;
import com.couchbase.client.scala.kv.GetAndLockOptions$;
import com.couchbase.client.scala.kv.GetAndTouchOptions;
import com.couchbase.client.scala.kv.GetAndTouchOptions$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.RemoveOptions$;
import com.couchbase.client.scala.kv.ReplaceOptions;
import com.couchbase.client.scala.kv.ReplaceOptions$;
import com.couchbase.client.scala.kv.ScanOptions;
import com.couchbase.client.scala.kv.ScanOptions$;
import com.couchbase.client.scala.kv.ScanResult;
import com.couchbase.client.scala.kv.ScanType;
import com.couchbase.client.scala.kv.TouchOptions;
import com.couchbase.client.scala.kv.TouchOptions$;
import com.couchbase.client.scala.kv.UnlockOptions;
import com.couchbase.client.scala.kv.UnlockOptions$;
import com.couchbase.client.scala.kv.UpsertOptions;
import com.couchbase.client.scala.kv.UpsertOptions$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.ExpiryUtil$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

public class Collection
implements CollectionBase {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Collection.class.getDeclaredField("collectionIdentifier$lzy1"));
    private ExecutionContext ec;
    private BinaryCollection binary;
    private Function1 kvTimeout;
    private Duration kvReadTimeout;
    private CoreKvOps kvOps;
    private volatile Object collectionIdentifier$lzy1;
    private final AsyncCollection async;
    private final String bucketName;

    public Collection(AsyncCollection async, String bucketName) {
        this.async = async;
        this.bucketName = bucketName;
        CollectionBase.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public BinaryCollection binary() {
        return this.binary;
    }

    public Function1 kvTimeout() {
        return this.kvTimeout;
    }

    @Override
    public Duration kvReadTimeout() {
        return this.kvReadTimeout;
    }

    @Override
    public CoreKvOps kvOps() {
        return this.kvOps;
    }

    @Override
    public CollectionIdentifier collectionIdentifier() {
        Object object = this.collectionIdentifier$lzy1;
        if (object instanceof CollectionIdentifier) {
            return (CollectionIdentifier)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CollectionIdentifier)this.collectionIdentifier$lzyINIT1();
    }

    private Object collectionIdentifier$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.collectionIdentifier$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CollectionIdentifier collectionIdentifier = null;
                    try {
                        collectionIdentifier = CollectionBase.collectionIdentifier$(this);
                        object2 = collectionIdentifier == null ? LazyVals.NullValue$.MODULE$ : collectionIdentifier;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.collectionIdentifier$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return collectionIdentifier;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void com$couchbase$client$scala$CollectionBase$_setter_$ec_$eq(ExecutionContext x$0) {
        this.ec = x$0;
    }

    @Override
    public void com$couchbase$client$scala$CollectionBase$_setter_$binary_$eq(BinaryCollection x$0) {
        this.binary = x$0;
    }

    @Override
    public void com$couchbase$client$scala$CollectionBase$_setter_$kvTimeout_$eq(Function1 x$0) {
        this.kvTimeout = x$0;
    }

    @Override
    public void com$couchbase$client$scala$CollectionBase$_setter_$kvReadTimeout_$eq(Duration x$0) {
        this.kvReadTimeout = x$0;
    }

    @Override
    public void com$couchbase$client$scala$CollectionBase$_setter_$kvOps_$eq(CoreKvOps x$0) {
        this.kvOps = x$0;
    }

    public AsyncCollection async() {
        return this.async;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public Try<GetResult> get(String id, GetOptions options) {
        return Try$.MODULE$.apply(() -> this.get$$anonfun$1(options, id)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreGetResult)result, this.async().environment(), options.transcoder()));
    }

    public GetOptions get$default$2() {
        return GetOptions$.MODULE$.Default();
    }

    public <T> Try<MutationResult> insert(String id, T content, InsertOptions options, JsonSerializer<T> serializer) {
        return Try$.MODULE$.apply(() -> this.insert$$anonfun$1(options, id, serializer, content)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result));
    }

    public <T> InsertOptions insert$default$3() {
        return InsertOptions$.MODULE$.Default();
    }

    public <T> Try<MutationResult> replace(String id, T content, ReplaceOptions options, JsonSerializer<T> serializer) {
        return Try$.MODULE$.apply(() -> this.replace$$anonfun$1(options, id, serializer, content)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result));
    }

    public <T> ReplaceOptions replace$default$3() {
        return ReplaceOptions$.MODULE$.Default();
    }

    public <T> Try<MutationResult> upsert(String id, T content, UpsertOptions options, JsonSerializer<T> serializer) {
        return Try$.MODULE$.apply(() -> this.upsert$$anonfun$1(options, id, serializer, content)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result));
    }

    public <T> UpsertOptions upsert$default$3() {
        return UpsertOptions$.MODULE$.Default();
    }

    public Try<MutationResult> remove(String id, RemoveOptions options) {
        return Try$.MODULE$.apply(() -> this.remove$$anonfun$1(options, id)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result));
    }

    public RemoveOptions remove$default$2() {
        return RemoveOptions$.MODULE$.Default();
    }

    public Try<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, MutateInOptions options) {
        return Try$.MODULE$.apply(() -> this.mutateIn$$anonfun$1(options, id, spec)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreSubdocMutateResult)result));
    }

    public MutateInOptions mutateIn$default$3() {
        return MutateInOptions$.MODULE$.Default();
    }

    public Try<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return Try$.MODULE$.apply(() -> this.getAndLock$$anonfun$1(options, id, lockTime)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreGetResult)result, this.async().environment(), options.transcoder()));
    }

    public GetAndLockOptions getAndLock$default$3() {
        return GetAndLockOptions$.MODULE$.Default();
    }

    public Try<BoxedUnit> unlock(String id, long cas, UnlockOptions options) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.unlock$$anonfun$1(options, id, cas);
            return BoxedUnit.UNIT;
        }).map((Function1)(JProcedure1 & Serializable)_$1 -> {});
    }

    public UnlockOptions unlock$default$3() {
        return UnlockOptions$.MODULE$.Default();
    }

    public Try<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return Try$.MODULE$.apply(() -> this.getAndTouch$$anonfun$1(options, id, expiry)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreGetResult)result, this.async().environment(), options.transcoder()));
    }

    public GetAndTouchOptions getAndTouch$default$3() {
        return GetAndTouchOptions$.MODULE$.Default();
    }

    public Try<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, LookupInOptions options) {
        return this.block((Future)this.async().lookupIn(id, spec, options));
    }

    public LookupInOptions lookupIn$default$3() {
        return LookupInOptions$.MODULE$.Default();
    }

    public Try<ExistsResult> exists(String id, ExistsOptions options) {
        return Try$.MODULE$.apply(() -> this.exists$$anonfun$1(options, id)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreExistsResult)result));
    }

    public ExistsOptions exists$default$2() {
        return ExistsOptions$.MODULE$.Default();
    }

    public Try<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return Try$.MODULE$.apply(() -> this.touch$$anonfun$1(options, id, expiry)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result));
    }

    public TouchOptions touch$default$3() {
        return TouchOptions$.MODULE$.Default();
    }

    public Try<Iterator<ScanResult>> scan(ScanType scanType, ScanOptions opts) {
        return this.block((Future)this.async().scan(scanType, opts));
    }

    public ScanOptions scan$default$2() {
        return ScanOptions$.MODULE$.Default();
    }

    private final CoreGetResult get$$anonfun$1(GetOptions options$1, String id$1) {
        return this.kvOps().getBlocking(CoreCommonConverters$.MODULE$.convert(options$1), id$1, CollectionConverters$.MODULE$.SeqHasAsJava(options$1.project()).asJava(), options$1.withExpiry());
    }

    private final Transcoder insert$$anonfun$1$$anonfun$1() {
        return this.async().environment().transcoder();
    }

    private final CoreMutationResult insert$$anonfun$1(InsertOptions options$3, String id$2, JsonSerializer serializer$1, Object content$1) {
        return this.kvOps().insertBlocking(CoreCommonConverters$.MODULE$.convert(options$3), id$2, CoreCommonConverters$.MODULE$.encoder((Transcoder)options$3.transcoder().getOrElse(this::insert$$anonfun$1$$anonfun$1), serializer$1, content$1), CoreCommonConverters$.MODULE$.convert(options$3.durability()), ExpiryUtil$.MODULE$.expiryActual(options$3.expiry(), options$3.expiryTime()));
    }

    private final Transcoder replace$$anonfun$1$$anonfun$1() {
        return this.async().environment().transcoder();
    }

    private final CoreMutationResult replace$$anonfun$1(ReplaceOptions options$4, String id$3, JsonSerializer serializer$2, Object content$2) {
        return this.kvOps().replaceBlocking(CoreCommonConverters$.MODULE$.convert(options$4), id$3, CoreCommonConverters$.MODULE$.encoder((Transcoder)options$4.transcoder().getOrElse(this::replace$$anonfun$1$$anonfun$1), serializer$2, content$2), options$4.cas(), CoreCommonConverters$.MODULE$.convert(options$4.durability()), ExpiryUtil$.MODULE$.expiryActual(options$4.expiry(), options$4.expiryTime()), options$4.preserveExpiry());
    }

    private final Transcoder upsert$$anonfun$1$$anonfun$1() {
        return this.async().environment().transcoder();
    }

    private final CoreMutationResult upsert$$anonfun$1(UpsertOptions options$5, String id$4, JsonSerializer serializer$3, Object content$3) {
        return this.kvOps().upsertBlocking(CoreCommonConverters$.MODULE$.convert(options$5), id$4, CoreCommonConverters$.MODULE$.encoder((Transcoder)options$5.transcoder().getOrElse(this::upsert$$anonfun$1$$anonfun$1), serializer$3, content$3), CoreCommonConverters$.MODULE$.convert(options$5.durability()), ExpiryUtil$.MODULE$.expiryActual(options$5.expiry(), options$5.expiryTime()), options$5.preserveExpiry());
    }

    private final CoreMutationResult remove$$anonfun$1(RemoveOptions options$6, String id$5) {
        return this.kvOps().removeBlocking(CoreCommonConverters$.MODULE$.convert(options$6), id$5, options$6.cas(), CoreCommonConverters$.MODULE$.convert(options$6.durability()));
    }

    private final CoreSubdocMutateResult mutateIn$$anonfun$1(MutateInOptions options$7, String id$6, Seq spec$1) {
        return this.kvOps().subdocMutateBlocking(CoreCommonConverters$.MODULE$.convert(options$7), id$6, () -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)spec$1.map((Function1 & Serializable)v -> v.convert())).asJava(), CoreCommonConverters$.MODULE$.convert(options$7.document()), options$7.cas(), CoreCommonConverters$.MODULE$.convert(options$7.durability()), ExpiryUtil$.MODULE$.expiryActual(options$7.expiry(), options$7.expiryTime()), options$7.preserveExpiry(), options$7.accessDeleted(), options$7.createAsDeleted());
    }

    private final CoreGetResult getAndLock$$anonfun$1(GetAndLockOptions options$8, String id$7, Duration lockTime$1) {
        return this.kvOps().getAndLockBlocking(CoreCommonConverters$.MODULE$.convert(options$8), id$7, CoreCommonConverters$.MODULE$.convert(lockTime$1));
    }

    private final void unlock$$anonfun$1(UnlockOptions options$10, String id$8, long cas$1) {
        this.kvOps().unlockBlocking(CoreCommonConverters$.MODULE$.convert(options$10), id$8, cas$1);
    }

    private final CoreGetResult getAndTouch$$anonfun$1(GetAndTouchOptions options$11, String id$9, Duration expiry$1) {
        return this.kvOps().getAndTouchBlocking(CoreCommonConverters$.MODULE$.convert(options$11), id$9, CoreCommonConverters$.MODULE$.convertExpiry(expiry$1));
    }

    private final CoreExistsResult exists$$anonfun$1(ExistsOptions options$13, String id$10) {
        return this.kvOps().existsBlocking(CoreCommonConverters$.MODULE$.convert(options$13), id$10);
    }

    private final CoreMutationResult touch$$anonfun$1(TouchOptions options$14, String id$11, Duration expiry$2) {
        return this.kvOps().touchBlocking(CoreCommonConverters$.MODULE$.convert(options$14), id$11, CoreCommonConverters$.MODULE$.convertExpiry(expiry$2));
    }
}

